package org.wildfly.swarm.config.undertow.subsystem.servletContainer.mimeMapping;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The servlet container mime mapping config
 */
@Address("/subsystem=undertow/servlet-container=*/mime-mapping=*")
public class MimeMapping<T extends MimeMapping> {

	private String key;
	private String value;

	public MimeMapping(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The mime type for this mapping
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The mime type for this mapping
	 */
	@SuppressWarnings("unchecked")
	public T value(String value) {
		this.value = value;
		return (T) this;
	}
}