/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.subsystem.configuration.reverseProxy;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.configuration.reverseProxy.host.Host;

@Address(value="/subsystem=undertow/configuration=handler/reverse-proxy=*")
public class ReverseProxy<T extends ReverseProxy> {
    private String key;
    private Integer cachedConnectionsPerThread;
    private Integer connectionIdleTimeout;
    private Integer connectionsPerThread;
    private Integer maxRequestTime;
    private Integer problemServerRetry;
    private Integer requestQueueSize;
    private String sessionCookieNames;
    private ReverseProxyResources subresources = new ReverseProxyResources();

    public ReverseProxy(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="cached-connections-per-thread")
    public Integer cachedConnectionsPerThread() {
        return this.cachedConnectionsPerThread;
    }

    public T cachedConnectionsPerThread(Integer value) {
        this.cachedConnectionsPerThread = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-idle-timeout")
    public Integer connectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public T connectionIdleTimeout(Integer value) {
        this.connectionIdleTimeout = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connections-per-thread")
    public Integer connectionsPerThread() {
        return this.connectionsPerThread;
    }

    public T connectionsPerThread(Integer value) {
        this.connectionsPerThread = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-request-time")
    public Integer maxRequestTime() {
        return this.maxRequestTime;
    }

    public T maxRequestTime(Integer value) {
        this.maxRequestTime = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="problem-server-retry")
    public Integer problemServerRetry() {
        return this.problemServerRetry;
    }

    public T problemServerRetry(Integer value) {
        this.problemServerRetry = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-queue-size")
    public Integer requestQueueSize() {
        return this.requestQueueSize;
    }

    public T requestQueueSize(Integer value) {
        this.requestQueueSize = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="session-cookie-names")
    public String sessionCookieNames() {
        return this.sessionCookieNames;
    }

    public T sessionCookieNames(String value) {
        this.sessionCookieNames = value;
        return (T)this;
    }

    public ReverseProxyResources subresources() {
        return this.subresources;
    }

    public T hosts(List<Host> value) {
        this.subresources.hosts.addAll(value);
        return (T)this;
    }

    public T host(Host value) {
        this.subresources.hosts.add(value);
        return (T)this;
    }

    public class ReverseProxyResources {
        private List<Host> hosts = new ArrayList<Host>();

        @Subresource
        public List<Host> hosts() {
            return this.hosts;
        }
    }
}

