/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.subsystem.server.host;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.server.host.filterRef.FilterRef;
import org.wildfly.swarm.config.undertow.subsystem.server.host.location.Location;
import org.wildfly.swarm.config.undertow.subsystem.server.host.setting.AccessLog;
import org.wildfly.swarm.config.undertow.subsystem.server.host.setting.SingleSignOn;

@Address(value="/subsystem=undertow/server=*/host=*")
public class Host<T extends Host> {
    private String key;
    private List<String> alias;
    private Integer defaultResponseCode;
    private String defaultWebModule;
    private Boolean disableConsoleRedirect;
    private HostResources subresources = new HostResources();
    private AccessLog accessLog;
    private SingleSignOn singleSignOn;

    public Host(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="alias")
    public List<String> alias() {
        return this.alias;
    }

    public T alias(List<String> value) {
        this.alias = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-response-code")
    public Integer defaultResponseCode() {
        return this.defaultResponseCode;
    }

    public T defaultResponseCode(Integer value) {
        this.defaultResponseCode = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-web-module")
    public String defaultWebModule() {
        return this.defaultWebModule;
    }

    public T defaultWebModule(String value) {
        this.defaultWebModule = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="disable-console-redirect")
    public Boolean disableConsoleRedirect() {
        return this.disableConsoleRedirect;
    }

    public T disableConsoleRedirect(Boolean value) {
        this.disableConsoleRedirect = value;
        return (T)this;
    }

    public HostResources subresources() {
        return this.subresources;
    }

    public T filterRefs(List<FilterRef> value) {
        this.subresources.filterRefs.addAll(value);
        return (T)this;
    }

    public T filterRef(FilterRef value) {
        this.subresources.filterRefs.add(value);
        return (T)this;
    }

    public T locations(List<Location> value) {
        this.subresources.locations.addAll(value);
        return (T)this;
    }

    public T location(Location value) {
        this.subresources.locations.add(value);
        return (T)this;
    }

    @Subresource
    public AccessLog accessLog() {
        return this.accessLog;
    }

    public T accessLog(AccessLog value) {
        this.accessLog = value;
        return (T)this;
    }

    @Subresource
    public SingleSignOn singleSignOn() {
        return this.singleSignOn;
    }

    public T singleSignOn(SingleSignOn value) {
        this.singleSignOn = value;
        return (T)this;
    }

    public class HostResources {
        private List<FilterRef> filterRefs = new ArrayList<FilterRef>();
        private List<Location> locations = new ArrayList<Location>();

        @Subresource
        public List<FilterRef> filterRefs() {
            return this.filterRefs;
        }

        @Subresource
        public List<Location> locations() {
            return this.locations;
        }
    }
}

