package org.wildfly.swarm.config.io.subsystem.bufferPool;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Defines buffer pool
 */
@Address("/subsystem=io/buffer-pool=*")
public class BufferPool<T extends BufferPool> {

	private String key;
	private Integer bufferSize;
	private Integer buffersPerSlice;
	private Boolean directBuffers;

	public BufferPool(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * How big is the buffer
	 */
	@ModelNodeBinding(detypedName = "buffer-size")
	public Integer bufferSize() {
		return this.bufferSize;
	}

	/**
	 * How big is the buffer
	 */
	@SuppressWarnings("unchecked")
	public T bufferSize(Integer value) {
		this.bufferSize = value;
		return (T) this;
	}

	/**
	 * How many buffers per slice
	 */
	@ModelNodeBinding(detypedName = "buffers-per-slice")
	public Integer buffersPerSlice() {
		return this.buffersPerSlice;
	}

	/**
	 * How many buffers per slice
	 */
	@SuppressWarnings("unchecked")
	public T buffersPerSlice(Integer value) {
		this.buffersPerSlice = value;
		return (T) this;
	}

	/**
	 * Does the buffer pool use direct buffers
	 */
	@ModelNodeBinding(detypedName = "direct-buffers")
	public Boolean directBuffers() {
		return this.directBuffers;
	}

	/**
	 * Does the buffer pool use direct buffers
	 */
	@SuppressWarnings("unchecked")
	public T directBuffers(Boolean value) {
		this.directBuffers = value;
		return (T) this;
	}
}