package org.wildfly.swarm.config.naming;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.naming.subsystem.binding.Binding;
import org.wildfly.swarm.config.naming.subsystem.service.RemoteNaming;
/**
 * The configuration of the naming subsystem.
 */
@Address("/subsystem=naming")
@Implicit
public class Naming<T extends Naming> {

	private String key;
	private NamingResources subresources = new NamingResources();
	private RemoteNaming remoteNaming;

	public Naming() {
		this.key = "naming";
	}

	public String getKey() {
		return this.key;
	}

	public NamingResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Binding objects to this subresource
	 * @return this
	 * @param value List of Binding objects.
	 */
	@SuppressWarnings("unchecked")
	public T bindings(List<Binding> value) {
		this.subresources.bindings.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Binding object to the list of subresources
	 * @param value The Binding to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T binding(Binding value) {
		this.subresources.bindings.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Naming
	 */
	public class NamingResources {
		/**
		 * JNDI bindings for primitive types
		 */
		private List<Binding> bindings = new java.util.ArrayList<>();

		/**
		 * Get the list of Binding resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Binding> bindings() {
			return this.bindings;
		}
	}

	/**
	 * The remote naming server
	 */
	@Subresource
	public RemoteNaming remoteNaming() {
		return this.remoteNaming;
	}

	/**
	 * The remote naming server
	 */
	@SuppressWarnings("unchecked")
	public T remoteNaming(RemoteNaming value) {
		this.remoteNaming = value;
		return (T) this;
	}
}