package org.wildfly.swarm.config.remoting.subsystem.connector;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.subsystem.connector.property.Property;
import org.wildfly.swarm.config.remoting.subsystem.connector.security.Sasl;
/**
 * The configuration of a Remoting connector.
 */
@Address("/subsystem=remoting/connector=*")
public class Connector<T extends Connector> {

	private String key;
	private String authenticationProvider;
	private String saslProtocol;
	private String securityRealm;
	private String serverName;
	private String socketBinding;
	private ConnectorResources subresources = new ConnectorResources();
	private Sasl sasl;

	public Connector(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The "authentication-provider" element contains the name of the authentication provider to use for incoming connections.
	 */
	@ModelNodeBinding(detypedName = "authentication-provider")
	public String authenticationProvider() {
		return this.authenticationProvider;
	}

	/**
	 * The "authentication-provider" element contains the name of the authentication provider to use for incoming connections.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationProvider(String value) {
		this.authenticationProvider = value;
		return (T) this;
	}

	/**
	 * The protocol to pass into the SASL mechanisms used for authentication.
	 */
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * The protocol to pass into the SASL mechanisms used for authentication.
	 */
	@SuppressWarnings("unchecked")
	public T saslProtocol(String value) {
		this.saslProtocol = value;
		return (T) this;
	}

	/**
	 * The associated security realm to use for authentication for this connector.
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The associated security realm to use for authentication for this connector.
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(String value) {
		this.securityRealm = value;
		return (T) this;
	}

	/**
	 * The server name to send in the initial message exchange and for SASL based authentication.
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The server name to send in the initial message exchange and for SASL based authentication.
	 */
	@SuppressWarnings("unchecked")
	public T serverName(String value) {
		this.serverName = value;
		return (T) this;
	}

	/**
	 * The name (or names) of the socket binding(s) to attach to.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The name (or names) of the socket binding(s) to attach to.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(String value) {
		this.socketBinding = value;
		return (T) this;
	}

	public ConnectorResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Property objects to this subresource
	 * @return this
	 * @param value List of Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T propertys(List<Property> value) {
		this.subresources.propertys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Property object to the list of subresources
	 * @param value The Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.propertys.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Connector
	 */
	public class ConnectorResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}

	/**
	 * The "sasl" element contains the SASL authentication configuration for this connector.
	 */
	@Subresource
	public Sasl sasl() {
		return this.sasl;
	}

	/**
	 * The "sasl" element contains the SASL authentication configuration for this connector.
	 */
	@SuppressWarnings("unchecked")
	public T sasl(Sasl value) {
		this.sasl = value;
		return (T) this;
	}
}