package org.wildfly.swarm.config.undertow.subsystem.configuration.modCluster.balancer.node.context;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Runtime representation of a mod_cluster context
 */
@Address("/subsystem=undertow/configuration=filter/mod-cluster=*/balancer=*/node=*/context=*")
public class Context<T extends Context> {

	private String key;
	private Integer requests;
	private String status;

	public Context(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of requests against this context
	 */
	@ModelNodeBinding(detypedName = "requests")
	public Integer requests() {
		return this.requests;
	}

	/**
	 * The number of requests against this context
	 */
	@SuppressWarnings("unchecked")
	public T requests(Integer value) {
		this.requests = value;
		return (T) this;
	}

	/**
	 * The status of this context
	 */
	@ModelNodeBinding(detypedName = "status")
	public String status() {
		return this.status;
	}

	/**
	 * The status of this context
	 */
	@SuppressWarnings("unchecked")
	public T status(String value) {
		this.status = value;
		return (T) this;
	}
}