package org.wildfly.swarm.config.undertow.subsystem.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.server.host.Host;
import org.wildfly.swarm.config.undertow.subsystem.server.httpListener.HttpListener;
import org.wildfly.swarm.config.undertow.subsystem.server.ajpListener.AjpListener;
import org.wildfly.swarm.config.undertow.subsystem.server.httpsListener.HttpsListener;
/**
 * A server
 */
@Address("/subsystem=undertow/server=*")
public class Server<T extends Server> {

	private String key;
	private String defaultHost;
	private String servletContainer;
	private ServerResources subresources = new ServerResources();

	public Server(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The servers default virtual host
	 */
	@ModelNodeBinding(detypedName = "default-host")
	public String defaultHost() {
		return this.defaultHost;
	}

	/**
	 * The servers default virtual host
	 */
	@SuppressWarnings("unchecked")
	public T defaultHost(String value) {
		this.defaultHost = value;
		return (T) this;
	}

	/**
	 * The servers default servlet container
	 */
	@ModelNodeBinding(detypedName = "servlet-container")
	public String servletContainer() {
		return this.servletContainer;
	}

	/**
	 * The servers default servlet container
	 */
	@SuppressWarnings("unchecked")
	public T servletContainer(String value) {
		this.servletContainer = value;
		return (T) this;
	}

	public ServerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Host objects to this subresource
	 * @return this
	 * @param value List of Host objects.
	 */
	@SuppressWarnings("unchecked")
	public T hosts(List<Host> value) {
		this.subresources.hosts.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Host object to the list of subresources
	 * @param value The Host to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T host(Host value) {
		this.subresources.hosts.add(value);
		return (T) this;
	}

	/**
	 * Add all HttpListener objects to this subresource
	 * @return this
	 * @param value List of HttpListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpListeners(List<HttpListener> value) {
		this.subresources.httpListeners.addAll(value);
		return (T) this;
	}

	/**
	 * Add the HttpListener object to the list of subresources
	 * @param value The HttpListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpListener(HttpListener value) {
		this.subresources.httpListeners.add(value);
		return (T) this;
	}

	/**
	 * Add all AjpListener objects to this subresource
	 * @return this
	 * @param value List of AjpListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T ajpListeners(List<AjpListener> value) {
		this.subresources.ajpListeners.addAll(value);
		return (T) this;
	}

	/**
	 * Add the AjpListener object to the list of subresources
	 * @param value The AjpListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ajpListener(AjpListener value) {
		this.subresources.ajpListeners.add(value);
		return (T) this;
	}

	/**
	 * Add all HttpsListener objects to this subresource
	 * @return this
	 * @param value List of HttpsListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpsListeners(List<HttpsListener> value) {
		this.subresources.httpsListeners.addAll(value);
		return (T) this;
	}

	/**
	 * Add the HttpsListener object to the list of subresources
	 * @param value The HttpsListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpsListener(HttpsListener value) {
		this.subresources.httpsListeners.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Server
	 */
	public class ServerResources {
		/**
		 * An Undertow host
		 */
		private List<Host> hosts = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<HttpListener> httpListeners = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<AjpListener> ajpListeners = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<HttpsListener> httpsListeners = new java.util.ArrayList<>();

		/**
		 * Get the list of Host resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Host> hosts() {
			return this.hosts;
		}

		/**
		 * Get the list of HttpListener resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpListener> httpListeners() {
			return this.httpListeners;
		}

		/**
		 * Get the list of AjpListener resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AjpListener> ajpListeners() {
			return this.ajpListeners;
		}

		/**
		 * Get the list of HttpsListener resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpsListener> httpsListeners() {
			return this.httpsListeners;
		}
	}
}