package org.wildfly.swarm.config.undertow.subsystem.server.host;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.server.host.filterRef.FilterRef;
import org.wildfly.swarm.config.undertow.subsystem.server.host.location.Location;
import org.wildfly.swarm.config.undertow.subsystem.server.host.setting.AccessLog;
import org.wildfly.swarm.config.undertow.subsystem.server.host.setting.SingleSignOn;
/**
 * An Undertow host
 */
@Address("/subsystem=undertow/server=*/host=*")
public class Host<T extends Host> {

	private String key;
	private List<String> alias;
	private Integer defaultResponseCode;
	private String defaultWebModule;
	private Boolean disableConsoleRedirect;
	private HostResources subresources = new HostResources();
	private AccessLog accessLog;
	private SingleSignOn singleSignOn;

	public Host(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Aliases for the host
	 */
	@ModelNodeBinding(detypedName = "alias")
	public List<String> alias() {
		return this.alias;
	}

	/**
	 * Aliases for the host
	 */
	@SuppressWarnings("unchecked")
	public T alias(List<String> value) {
		this.alias = value;
		return (T) this;
	}

	/**
	 * If set, this will be response code sent back in case requested context does not exist on server.
	 */
	@ModelNodeBinding(detypedName = "default-response-code")
	public Integer defaultResponseCode() {
		return this.defaultResponseCode;
	}

	/**
	 * If set, this will be response code sent back in case requested context does not exist on server.
	 */
	@SuppressWarnings("unchecked")
	public T defaultResponseCode(Integer value) {
		this.defaultResponseCode = value;
		return (T) this;
	}

	/**
	 * Default web module
	 */
	@ModelNodeBinding(detypedName = "default-web-module")
	public String defaultWebModule() {
		return this.defaultWebModule;
	}

	/**
	 * Default web module
	 */
	@SuppressWarnings("unchecked")
	public T defaultWebModule(String value) {
		this.defaultWebModule = value;
		return (T) this;
	}

	/**
	 * if set to true, /console redirect wont be enabled for this host, default is false
	 */
	@ModelNodeBinding(detypedName = "disable-console-redirect")
	public Boolean disableConsoleRedirect() {
		return this.disableConsoleRedirect;
	}

	/**
	 * if set to true, /console redirect wont be enabled for this host, default is false
	 */
	@SuppressWarnings("unchecked")
	public T disableConsoleRedirect(Boolean value) {
		this.disableConsoleRedirect = value;
		return (T) this;
	}

	public HostResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all FilterRef objects to this subresource
	 * @return this
	 * @param value List of FilterRef objects.
	 */
	@SuppressWarnings("unchecked")
	public T filterRefs(List<FilterRef> value) {
		this.subresources.filterRefs.addAll(value);
		return (T) this;
	}

	/**
	 * Add the FilterRef object to the list of subresources
	 * @param value The FilterRef to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filterRef(FilterRef value) {
		this.subresources.filterRefs.add(value);
		return (T) this;
	}

	/**
	 * Add all Location objects to this subresource
	 * @return this
	 * @param value List of Location objects.
	 */
	@SuppressWarnings("unchecked")
	public T locations(List<Location> value) {
		this.subresources.locations.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Location object to the list of subresources
	 * @param value The Location to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T location(Location value) {
		this.subresources.locations.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Host
	 */
	public class HostResources {
		/**
		 * Reference to filter
		 */
		private List<FilterRef> filterRefs = new java.util.ArrayList<>();
		/**
		 * Holds configuration of location resource
		 */
		private List<Location> locations = new java.util.ArrayList<>();

		/**
		 * Get the list of FilterRef resources
		 * @return the list of resources
		 */
		@Subresource
		public List<FilterRef> filterRefs() {
			return this.filterRefs;
		}

		/**
		 * Get the list of Location resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Location> locations() {
			return this.locations;
		}
	}

	/**
	 * The access log configuration for this virtual server.
	 */
	@Subresource
	public AccessLog accessLog() {
		return this.accessLog;
	}

	/**
	 * The access log configuration for this virtual server.
	 */
	@SuppressWarnings("unchecked")
	public T accessLog(AccessLog value) {
		this.accessLog = value;
		return (T) this;
	}

	/**
	 * The SSO configuration for this virtual server.
	 */
	@Subresource
	public SingleSignOn singleSignOn() {
		return this.singleSignOn;
	}

	/**
	 * The SSO configuration for this virtual server.
	 */
	@SuppressWarnings("unchecked")
	public T singleSignOn(SingleSignOn value) {
		this.singleSignOn = value;
		return (T) this;
	}
}