package org.wildfly.swarm.config.undertow.subsystem.server.host.setting;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The access log configuration for this virtual server.
 */
@Address("/subsystem=undertow/server=*/host=*/setting=access-log")
@Implicit
public class AccessLog<T extends AccessLog> {

	private String key;
	private String directory;
	private Boolean extended;
	private String pattern;
	private String predicate;
	private String prefix;
	private String relativeTo;
	private Boolean rotate;
	private String suffix;
	private Boolean useServerLog;
	private String worker;

	public AccessLog() {
		this.key = "access-log";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Directory in which to save logs
	 */
	@ModelNodeBinding(detypedName = "directory")
	public String directory() {
		return this.directory;
	}

	/**
	 * Directory in which to save logs
	 */
	@SuppressWarnings("unchecked")
	public T directory(String value) {
		this.directory = value;
		return (T) this;
	}

	/**
	 * If the log uses the extended log file format
	 */
	@ModelNodeBinding(detypedName = "extended")
	public Boolean extended() {
		return this.extended;
	}

	/**
	 * If the log uses the extended log file format
	 */
	@SuppressWarnings("unchecked")
	public T extended(Boolean value) {
		this.extended = value;
		return (T) this;
	}

	/**
	 * The access log pattern.
	 */
	@ModelNodeBinding(detypedName = "pattern")
	public String pattern() {
		return this.pattern;
	}

	/**
	 * The access log pattern.
	 */
	@SuppressWarnings("unchecked")
	public T pattern(String value) {
		this.pattern = value;
		return (T) this;
	}

	/**
	 * Predicate that determines if the request should be logged
	 */
	@ModelNodeBinding(detypedName = "predicate")
	public String predicate() {
		return this.predicate;
	}

	/**
	 * Predicate that determines if the request should be logged
	 */
	@SuppressWarnings("unchecked")
	public T predicate(String value) {
		this.predicate = value;
		return (T) this;
	}

	/**
	 * Prefix for the log file name.
	 */
	@ModelNodeBinding(detypedName = "prefix")
	public String prefix() {
		return this.prefix;
	}

	/**
	 * Prefix for the log file name.
	 */
	@SuppressWarnings("unchecked")
	public T prefix(String value) {
		this.prefix = value;
		return (T) this;
	}

	/**
	 * The directory the path is relative to
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The directory the path is relative to
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(String value) {
		this.relativeTo = value;
		return (T) this;
	}

	/**
	 * Rotate the access log every day.
	 */
	@ModelNodeBinding(detypedName = "rotate")
	public Boolean rotate() {
		return this.rotate;
	}

	/**
	 * Rotate the access log every day.
	 */
	@SuppressWarnings("unchecked")
	public T rotate(Boolean value) {
		this.rotate = value;
		return (T) this;
	}

	/**
	 * Suffix for the log file name.
	 */
	@ModelNodeBinding(detypedName = "suffix")
	public String suffix() {
		return this.suffix;
	}

	/**
	 * Suffix for the log file name.
	 */
	@SuppressWarnings("unchecked")
	public T suffix(String value) {
		this.suffix = value;
		return (T) this;
	}

	/**
	 * If the log should be written to the server log, rather than a separate file. Defaults to false.
	 */
	@ModelNodeBinding(detypedName = "use-server-log")
	public Boolean useServerLog() {
		return this.useServerLog;
	}

	/**
	 * If the log should be written to the server log, rather than a separate file. Defaults to false.
	 */
	@SuppressWarnings("unchecked")
	public T useServerLog(Boolean value) {
		this.useServerLog = value;
		return (T) this;
	}

	/**
	 * Name of the worker to use for logging
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * Name of the worker to use for logging
	 */
	@SuppressWarnings("unchecked")
	public T worker(String value) {
		this.worker = value;
		return (T) this;
	}
}