package org.wildfly.swarm.config;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.jca.subsystem.distributedWorkmanager.DistributedWorkmanager;
import org.wildfly.swarm.config.jca.subsystem.workmanager.Workmanager;
import org.wildfly.swarm.config.jca.subsystem.bootstrapContext.BootstrapContext;
import org.wildfly.swarm.config.jca.subsystem.SubsystemCachedConnectionManager;
import org.wildfly.swarm.config.jca.subsystem.SubsystemBeanValidation;
import org.wildfly.swarm.config.jca.subsystem.SubsystemTracer;
import org.wildfly.swarm.config.jca.subsystem.SubsystemArchiveValidation;
/**
 * The Java EE Connector Architecture (JCA) subsystem providing general configuration for resource adapters
 */
@Address("/subsystem=jca")
@Implicit
public class Jca<T extends Jca> {

	private String key;
	private JcaResources subresources = new JcaResources();
	private SubsystemCachedConnectionManager subsystemCachedConnectionManager;
	private SubsystemBeanValidation subsystemBeanValidation;
	private SubsystemTracer subsystemTracer;
	private SubsystemArchiveValidation subsystemArchiveValidation;

	public Jca() {
		this.key = "jca";
	}

	public String getKey() {
		return this.key;
	}

	public JcaResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all DistributedWorkmanager objects to this subresource
	 * @return this
	 * @param value List of DistributedWorkmanager objects.
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanagers(List<DistributedWorkmanager> value) {
		this.subresources.distributedWorkmanagers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the DistributedWorkmanager object to the list of subresources
	 * @param value The DistributedWorkmanager to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanager(DistributedWorkmanager value) {
		this.subresources.distributedWorkmanagers.add(value);
		return (T) this;
	}

	/**
	 * Add all Workmanager objects to this subresource
	 * @return this
	 * @param value List of Workmanager objects.
	 */
	@SuppressWarnings("unchecked")
	public T workmanagers(List<Workmanager> value) {
		this.subresources.workmanagers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Workmanager object to the list of subresources
	 * @param value The Workmanager to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(Workmanager value) {
		this.subresources.workmanagers.add(value);
		return (T) this;
	}

	/**
	 * Add all BootstrapContext objects to this subresource
	 * @return this
	 * @param value List of BootstrapContext objects.
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContexts(List<BootstrapContext> value) {
		this.subresources.bootstrapContexts.addAll(value);
		return (T) this;
	}

	/**
	 * Add the BootstrapContext object to the list of subresources
	 * @param value The BootstrapContext to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContext(BootstrapContext value) {
		this.subresources.bootstrapContexts.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Jca
	 */
	public class JcaResources {
		/**
		 * DistributedWorkManager for resource adapters
		 */
		private List<DistributedWorkmanager> distributedWorkmanagers = new java.util.ArrayList<>();
		/**
		 * WorkManager for resource adapters
		 */
		private List<Workmanager> workmanagers = new java.util.ArrayList<>();
		/**
		 * Bootstrap context for resource adapters
		 */
		private List<BootstrapContext> bootstrapContexts = new java.util.ArrayList<>();

		/**
		 * Get the list of DistributedWorkmanager resources
		 * @return the list of resources
		 */
		@Subresource
		public List<DistributedWorkmanager> distributedWorkmanagers() {
			return this.distributedWorkmanagers;
		}

		/**
		 * Get the list of Workmanager resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Workmanager> workmanagers() {
			return this.workmanagers;
		}

		/**
		 * Get the list of BootstrapContext resources
		 * @return the list of resources
		 */
		@Subresource
		public List<BootstrapContext> bootstrapContexts() {
			return this.bootstrapContexts;
		}
	}

	/**
	 * Cached connection manager for resource adapters
	 */
	@Subresource
	public SubsystemCachedConnectionManager subsystemCachedConnectionManager() {
		return this.subsystemCachedConnectionManager;
	}

	/**
	 * Cached connection manager for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T subsystemCachedConnectionManager(
			SubsystemCachedConnectionManager value) {
		this.subsystemCachedConnectionManager = value;
		return (T) this;
	}

	/**
	 * Bean validation (JSR-303) for resource adapters
	 */
	@Subresource
	public SubsystemBeanValidation subsystemBeanValidation() {
		return this.subsystemBeanValidation;
	}

	/**
	 * Bean validation (JSR-303) for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T subsystemBeanValidation(SubsystemBeanValidation value) {
		this.subsystemBeanValidation = value;
		return (T) this;
	}

	/**
	 * Tracer for resource adapters
	 */
	@Subresource
	public SubsystemTracer subsystemTracer() {
		return this.subsystemTracer;
	}

	/**
	 * Tracer for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T subsystemTracer(SubsystemTracer value) {
		this.subsystemTracer = value;
		return (T) this;
	}

	/**
	 * Archive validation for resource adapters
	 */
	@Subresource
	public SubsystemArchiveValidation subsystemArchiveValidation() {
		return this.subsystemArchiveValidation;
	}

	/**
	 * Archive validation for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T subsystemArchiveValidation(SubsystemArchiveValidation value) {
		this.subsystemArchiveValidation = value;
		return (T) this;
	}
}