package org.wildfly.swarm.config.ee.subsystem.contextService;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A context service
 */
@Address("/subsystem=ee/context-service=*")
public class ContextService<T extends ContextService> {

	private String key;
	private String jndiName;
	private Boolean useTransactionSetupProvider;

	public ContextService(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The JNDI Name to lookup the context service.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The JNDI Name to lookup the context service.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		this.jndiName = value;
		return (T) this;
	}

	/**
	 * Flag which indicates if the transaction setup provider should be used
	 */
	@ModelNodeBinding(detypedName = "use-transaction-setup-provider")
	public Boolean useTransactionSetupProvider() {
		return this.useTransactionSetupProvider;
	}

	/**
	 * Flag which indicates if the transaction setup provider should be used
	 */
	@SuppressWarnings("unchecked")
	public T useTransactionSetupProvider(Boolean value) {
		this.useTransactionSetupProvider = value;
		return (T) this;
	}
}