package org.wildfly.swarm.config.ejb3.subsystem;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.ejb3.subsystem.service.channelCreationOptions.ChannelCreationOptions;
/**
 * The EJB3 Remote Service
 */
@Address("/subsystem=ejb3/service=remote")
@Implicit
public class ServiceRemote<T extends ServiceRemote> {

	private String key;
	private String cluster;
	private String connectorRef;
	private String threadPoolName;
	private ServiceRemoteResources subresources = new ServiceRemoteResources();

	public ServiceRemote() {
		this.key = "remote";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the clustered cache container which will be used to store/access the client-mappings of the EJB remoting connector's socket-binding on each node, in the cluster
	 */
	@ModelNodeBinding(detypedName = "cluster")
	public String cluster() {
		return this.cluster;
	}

	/**
	 * The name of the clustered cache container which will be used to store/access the client-mappings of the EJB remoting connector's socket-binding on each node, in the cluster
	 */
	@SuppressWarnings("unchecked")
	public T cluster(String value) {
		this.cluster = value;
		return (T) this;
	}

	/**
	 * The name of the connector on which the EJB3 remoting channel is registered
	 */
	@ModelNodeBinding(detypedName = "connector-ref")
	public String connectorRef() {
		return this.connectorRef;
	}

	/**
	 * The name of the connector on which the EJB3 remoting channel is registered
	 */
	@SuppressWarnings("unchecked")
	public T connectorRef(String value) {
		this.connectorRef = value;
		return (T) this;
	}

	/**
	 * The name of the thread pool that handles remote invocations
	 */
	@ModelNodeBinding(detypedName = "thread-pool-name")
	public String threadPoolName() {
		return this.threadPoolName;
	}

	/**
	 * The name of the thread pool that handles remote invocations
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolName(String value) {
		this.threadPoolName = value;
		return (T) this;
	}

	public ServiceRemoteResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ChannelCreationOptions objects to this subresource
	 * @return this
	 * @param value List of ChannelCreationOptions objects.
	 */
	@SuppressWarnings("unchecked")
	public T channelCreationOptions(List<ChannelCreationOptions> value) {
		this.subresources.channelCreationOptions.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ChannelCreationOptions object to the list of subresources
	 * @param value The ChannelCreationOptions to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T channelCreationOptions(ChannelCreationOptions value) {
		this.subresources.channelCreationOptions.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for ServiceRemote
	 */
	public class ServiceRemoteResources {
		/**
		 * The options that will be used during the EJB remote channel creation
		 */
		private List<ChannelCreationOptions> channelCreationOptions = new java.util.ArrayList<>();

		/**
		 * Get the list of ChannelCreationOptions resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ChannelCreationOptions> channelCreationOptions() {
			return this.channelCreationOptions;
		}
	}
}