package org.wildfly.swarm.config.ejb3.subsystem.filePassivationStore;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A file system based passivation store
 */
@Address("/subsystem=ejb3/file-passivation-store=*")
public class FilePassivationStore<T extends FilePassivationStore> {

	private String key;
	private Long idleTimeout;
	private Integer maxSize;

	public FilePassivationStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@ModelNodeBinding(detypedName = "idle-timeout")
	public Long idleTimeout() {
		return this.idleTimeout;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@SuppressWarnings("unchecked")
	public T idleTimeout(Long value) {
		this.idleTimeout = value;
		return (T) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@ModelNodeBinding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public T maxSize(Integer value) {
		this.maxSize = value;
		return (T) this;
	}
}