package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Defines a thread pool used for asynchronous cache listener notifications.
 */
@Address("/subsystem=infinispan/cache-container=*/thread-pool=listener")
@Implicit
public class ThreadPoolListener<T extends ThreadPoolListener> {

	private String key;
	private Long keepaliveTime;
	private Integer maxThreads;
	private Integer minThreads;
	private Integer queueLength;

	public ThreadPoolListener() {
		this.key = "listener";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Long keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@SuppressWarnings("unchecked")
	public T keepaliveTime(Long value) {
		this.keepaliveTime = value;
		return (T) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public T maxThreads(Integer value) {
		this.maxThreads = value;
		return (T) this;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "min-threads")
	public Integer minThreads() {
		return this.minThreads;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public T minThreads(Integer value) {
		this.minThreads = value;
		return (T) this;
	}

	/**
	 * The queue length.
	 */
	@ModelNodeBinding(detypedName = "queue-length")
	public Integer queueLength() {
		return this.queueLength;
	}

	/**
	 * The queue length.
	 */
	@SuppressWarnings("unchecked")
	public T queueLength(Integer value) {
		this.queueLength = value;
		return (T) this;
	}
}