package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.subsystem.infinispan.cacheContainer.distributedCache.component.backups.backup.Backup;
/**
 * The remote backups for this cache.
 */
@Address("/subsystem=infinispan/cache-container=*/distributed-cache=*/component=backups")
@Implicit
public class ComponentBackups<T extends ComponentBackups> {

	private String key;
	private ComponentBackupsResources subresources = new ComponentBackupsResources();

	public ComponentBackups() {
		this.key = "backups";
	}

	public String getKey() {
		return this.key;
	}

	public ComponentBackupsResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Backup objects to this subresource
	 * @return this
	 * @param value List of Backup objects.
	 */
	@SuppressWarnings("unchecked")
	public T backups(List<Backup> value) {
		this.subresources.backups.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Backup object to the list of subresources
	 * @param value The Backup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T backup(Backup value) {
		this.subresources.backups.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for ComponentBackups
	 */
	public class ComponentBackupsResources {
		/**
		 * A backup site to which to replicate this cache.
		 */
		private List<Backup> backups = new java.util.ArrayList<>();

		/**
		 * Get the list of Backup resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Backup> backups() {
			return this.backups;
		}
	}
}