package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The cache eviction configuration.
 */
@Address("/subsystem=infinispan/cache-container=*/distributed-cache=*/component=eviction")
@Implicit
public class ComponentEviction<T extends ComponentEviction> {

	private String key;
	private Long evictions;
	private Long maxEntries;
	private String strategy;

	public ComponentEviction() {
		this.key = "eviction";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of cache eviction operations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "evictions")
	public Long evictions() {
		return this.evictions;
	}

	/**
	 * The number of cache eviction operations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T evictions(Long value) {
		this.evictions = value;
		return (T) this;
	}

	/**
	 * Maximum number of entries in a cache instance. If selected value is not a power of two the actual value will default to the least power of two larger than selected value. -1 means no limit.
	 */
	@ModelNodeBinding(detypedName = "max-entries")
	public Long maxEntries() {
		return this.maxEntries;
	}

	/**
	 * Maximum number of entries in a cache instance. If selected value is not a power of two the actual value will default to the least power of two larger than selected value. -1 means no limit.
	 */
	@SuppressWarnings("unchecked")
	public T maxEntries(Long value) {
		this.maxEntries = value;
		return (T) this;
	}

	/**
	 * Sets the cache eviction strategy. Available options are 'UNORDERED', 'FIFO', 'LRU', 'LIRS' and 'NONE' (to disable eviction).
	 */
	@ModelNodeBinding(detypedName = "strategy")
	public String strategy() {
		return this.strategy;
	}

	/**
	 * Sets the cache eviction strategy. Available options are 'UNORDERED', 'FIFO', 'LRU', 'LIRS' and 'NONE' (to disable eviction).
	 */
	@SuppressWarnings("unchecked")
	public T strategy(String value) {
		this.strategy = value;
		return (T) this;
	}
}