package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The cache expiration configuration.
 */
@Address("/subsystem=infinispan/cache-container=*/distributed-cache=*/component=expiration")
@Implicit
public class ComponentExpiration<T extends ComponentExpiration> {

	private String key;
	private Long interval;
	private Long lifespan;
	private Long maxIdle;

	public ComponentExpiration() {
		this.key = "expiration";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Interval (in milliseconds) between subsequent runs to purge expired entries from memory and any cache stores. If you wish to disable the periodic eviction process altogether, set wakeupInterval to -1.
	 */
	@ModelNodeBinding(detypedName = "interval")
	public Long interval() {
		return this.interval;
	}

	/**
	 * Interval (in milliseconds) between subsequent runs to purge expired entries from memory and any cache stores. If you wish to disable the periodic eviction process altogether, set wakeupInterval to -1.
	 */
	@SuppressWarnings("unchecked")
	public T interval(Long value) {
		this.interval = value;
		return (T) this;
	}

	/**
	 * Maximum lifespan of a cache entry, after which the entry is expired cluster-wide, in milliseconds. -1 means the entries never expire.
	 */
	@ModelNodeBinding(detypedName = "lifespan")
	public Long lifespan() {
		return this.lifespan;
	}

	/**
	 * Maximum lifespan of a cache entry, after which the entry is expired cluster-wide, in milliseconds. -1 means the entries never expire.
	 */
	@SuppressWarnings("unchecked")
	public T lifespan(Long value) {
		this.lifespan = value;
		return (T) this;
	}

	/**
	 * Maximum idle time a cache entry will be maintained in the cache, in milliseconds. If the idle time is exceeded, the entry will be expired cluster-wide. -1 means the entries never expire.
	 */
	@ModelNodeBinding(detypedName = "max-idle")
	public Long maxIdle() {
		return this.maxIdle;
	}

	/**
	 * Maximum idle time a cache entry will be maintained in the cache, in milliseconds. If the idle time is exceeded, the entry will be expired cluster-wide. -1 means the entries never expire.
	 */
	@SuppressWarnings("unchecked")
	public T maxIdle(Long value) {
		this.maxIdle = value;
		return (T) this;
	}
}