package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.ComponentEviction;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.ComponentExpiration;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.StoreCustom;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.StoreNone;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.ComponentBackupFor;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.ComponentTransaction;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.StoreBinaryJdbc;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.StoreStringJdbc;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.StoreFile;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.ComponentStateTransfer;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.ComponentPartitionHandling;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.ComponentLocking;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.ComponentBackups;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.StoreMixedJdbc;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.StoreRemote;
/**
 * A distributed cache configuration.
 */
@Address("/subsystem=infinispan/cache-container=*/distributed-cache=*")
public class DistributedCache<T extends DistributedCache> {

	private String key;
	private Long activations;
	private Long averageReadTime;
	private Long averageReplicationTime;
	private Long averageWriteTime;
	private String cacheStatus;
	private Double capacityFactor;
	private String consistentHashStrategy;
	private Long elapsedTime;
	private Double hitRatio;
	private Long hits;
	private Long invalidations;
	private String jndiName;
	private Long l1Lifespan;
	private Long misses;
	private String mode;
	private String module;
	private Integer numberOfEntries;
	private Integer owners;
	private Long passivations;
	private Long queueFlushInterval;
	private Integer queueSize;
	private Double readWriteRatio;
	private Long remoteTimeout;
	private Long removeHits;
	private Long removeMisses;
	private Long replicationCount;
	private Long replicationFailures;
	private Integer segments;
	private Boolean statisticsEnabled;
	private Long stores;
	private Double successRatio;
	private Long timeSinceReset;
	private ComponentEviction componentEviction;
	private ComponentExpiration componentExpiration;
	private StoreCustom storeCustom;
	private StoreNone storeNone;
	private ComponentBackupFor componentBackupFor;
	private ComponentTransaction componentTransaction;
	private StoreBinaryJdbc storeBinaryJdbc;
	private StoreStringJdbc storeStringJdbc;
	private StoreFile storeFile;
	private ComponentStateTransfer componentStateTransfer;
	private ComponentPartitionHandling componentPartitionHandling;
	private ComponentLocking componentLocking;
	private ComponentBackups componentBackups;
	private StoreMixedJdbc storeMixedJdbc;
	private StoreRemote storeRemote;

	public DistributedCache(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "activations")
	public Long activations() {
		return this.activations;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T activations(Long value) {
		this.activations = value;
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-read-time")
	public Long averageReadTime() {
		return this.averageReadTime;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageReadTime(Long value) {
		this.averageReadTime = value;
		return (T) this;
	}

	/**
	 * The average time taken to replicate data around the cluster. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-replication-time")
	public Long averageReplicationTime() {
		return this.averageReplicationTime;
	}

	/**
	 * The average time taken to replicate data around the cluster. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageReplicationTime(Long value) {
		this.averageReplicationTime = value;
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-write-time")
	public Long averageWriteTime() {
		return this.averageWriteTime;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageWriteTime(Long value) {
		this.averageWriteTime = value;
		return (T) this;
	}

	/**
	 * The status of the cache component. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-status")
	public String cacheStatus() {
		return this.cacheStatus;
	}

	/**
	 * The status of the cache component. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T cacheStatus(String value) {
		this.cacheStatus = value;
		return (T) this;
	}

	/**
	 * Controls the proportion of entries that will reside on the local node, compared to the other nodes in the cluster.
	 */
	@ModelNodeBinding(detypedName = "capacity-factor")
	public Double capacityFactor() {
		return this.capacityFactor;
	}

	/**
	 * Controls the proportion of entries that will reside on the local node, compared to the other nodes in the cluster.
	 */
	@SuppressWarnings("unchecked")
	public T capacityFactor(Double value) {
		this.capacityFactor = value;
		return (T) this;
	}

	/**
	 * Defines the consistent hash strategy for the cache.
	 */
	@ModelNodeBinding(detypedName = "consistent-hash-strategy")
	public String consistentHashStrategy() {
		return this.consistentHashStrategy;
	}

	/**
	 * Defines the consistent hash strategy for the cache.
	 */
	@SuppressWarnings("unchecked")
	public T consistentHashStrategy(String value) {
		this.consistentHashStrategy = value;
		return (T) this;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "elapsed-time")
	public Long elapsedTime() {
		return this.elapsedTime;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T elapsedTime(Long value) {
		this.elapsedTime = value;
		return (T) this;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hit-ratio")
	public Double hitRatio() {
		return this.hitRatio;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T hitRatio(Double value) {
		this.hitRatio = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hits")
	public Long hits() {
		return this.hits;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T hits(Long value) {
		this.hits = value;
		return (T) this;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "invalidations")
	public Long invalidations() {
		return this.invalidations;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T invalidations(Long value) {
		this.invalidations = value;
		return (T) this;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		this.jndiName = value;
		return (T) this;
	}

	/**
	 * Maximum lifespan of an entry placed in the L1 cache. This element configures the L1 cache behavior in 'distributed' caches instances. In any other cache modes, this element is ignored.
	 */
	@ModelNodeBinding(detypedName = "l1-lifespan")
	public Long l1Lifespan() {
		return this.l1Lifespan;
	}

	/**
	 * Maximum lifespan of an entry placed in the L1 cache. This element configures the L1 cache behavior in 'distributed' caches instances. In any other cache modes, this element is ignored.
	 */
	@SuppressWarnings("unchecked")
	public T l1Lifespan(Long value) {
		this.l1Lifespan = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "misses")
	public Long misses() {
		return this.misses;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T misses(Long value) {
		this.misses = value;
		return (T) this;
	}

	/**
	 * Sets the clustered cache mode, ASYNC for asynchronous operation, or SYNC for synchronous operation.
	 */
	@ModelNodeBinding(detypedName = "mode")
	public String mode() {
		return this.mode;
	}

	/**
	 * Sets the clustered cache mode, ASYNC for asynchronous operation, or SYNC for synchronous operation.
	 */
	@SuppressWarnings("unchecked")
	public T mode(String value) {
		this.mode = value;
		return (T) this;
	}

	/**
	 * The module whose class loader should be used when building this cache's configuration.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module whose class loader should be used when building this cache's configuration.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		this.module = value;
		return (T) this;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-entries")
	public Integer numberOfEntries() {
		return this.numberOfEntries;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfEntries(Integer value) {
		this.numberOfEntries = value;
		return (T) this;
	}

	/**
	 * Number of cluster-wide replicas for each cache entry.
	 */
	@ModelNodeBinding(detypedName = "owners")
	public Integer owners() {
		return this.owners;
	}

	/**
	 * Number of cluster-wide replicas for each cache entry.
	 */
	@SuppressWarnings("unchecked")
	public T owners(Integer value) {
		this.owners = value;
		return (T) this;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "passivations")
	public Long passivations() {
		return this.passivations;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T passivations(Long value) {
		this.passivations = value;
		return (T) this;
	}

	/**
	 * In ASYNC mode, this attribute controls how often the asynchronous thread used to flush the replication queue runs. This should be a positive integer which represents thread wakeup time in milliseconds.
	 */
	@ModelNodeBinding(detypedName = "queue-flush-interval")
	public Long queueFlushInterval() {
		return this.queueFlushInterval;
	}

	/**
	 * In ASYNC mode, this attribute controls how often the asynchronous thread used to flush the replication queue runs. This should be a positive integer which represents thread wakeup time in milliseconds.
	 */
	@SuppressWarnings("unchecked")
	public T queueFlushInterval(Long value) {
		this.queueFlushInterval = value;
		return (T) this;
	}

	/**
	 * In ASYNC mode, this attribute can be used to trigger flushing of the queue when it reaches a specific threshold.
	 */
	@ModelNodeBinding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * In ASYNC mode, this attribute can be used to trigger flushing of the queue when it reaches a specific threshold.
	 */
	@SuppressWarnings("unchecked")
	public T queueSize(Integer value) {
		this.queueSize = value;
		return (T) this;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "read-write-ratio")
	public Double readWriteRatio() {
		return this.readWriteRatio;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T readWriteRatio(Double value) {
		this.readWriteRatio = value;
		return (T) this;
	}

	/**
	 * In SYNC mode, the timeout (in ms) used to wait for an acknowledgment when making a remote call, after which the call is aborted and an exception is thrown.
	 */
	@ModelNodeBinding(detypedName = "remote-timeout")
	public Long remoteTimeout() {
		return this.remoteTimeout;
	}

	/**
	 * In SYNC mode, the timeout (in ms) used to wait for an acknowledgment when making a remote call, after which the call is aborted and an exception is thrown.
	 */
	@SuppressWarnings("unchecked")
	public T remoteTimeout(Long value) {
		this.remoteTimeout = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-hits")
	public Long removeHits() {
		return this.removeHits;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T removeHits(Long value) {
		this.removeHits = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-misses")
	public Long removeMisses() {
		return this.removeMisses;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T removeMisses(Long value) {
		this.removeMisses = value;
		return (T) this;
	}

	/**
	 * The number of times data was replicated around the cluster. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "replication-count")
	public Long replicationCount() {
		return this.replicationCount;
	}

	/**
	 * The number of times data was replicated around the cluster. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T replicationCount(Long value) {
		this.replicationCount = value;
		return (T) this;
	}

	/**
	 * The number of data replication failures. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "replication-failures")
	public Long replicationFailures() {
		return this.replicationFailures;
	}

	/**
	 * The number of data replication failures. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T replicationFailures(Long value) {
		this.replicationFailures = value;
		return (T) this;
	}

	/**
	 * Controls the number of hash space segments which is the granularity for key distribution in the cluster. Value must be strictly positive.
	 */
	@ModelNodeBinding(detypedName = "segments")
	public Integer segments() {
		return this.segments;
	}

	/**
	 * Controls the number of hash space segments which is the granularity for key distribution in the cluster. Value must be strictly positive.
	 */
	@SuppressWarnings("unchecked")
	public T segments(Integer value) {
		this.segments = value;
		return (T) this;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(Boolean value) {
		this.statisticsEnabled = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute put operations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "stores")
	public Long stores() {
		return this.stores;
	}

	/**
	 * The number of cache attribute put operations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T stores(Long value) {
		this.stores = value;
		return (T) this;
	}

	/**
	 * The data replication success ratio (successes/successes+failures). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "success-ratio")
	public Double successRatio() {
		return this.successRatio;
	}

	/**
	 * The data replication success ratio (successes/successes+failures). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T successRatio(Double value) {
		this.successRatio = value;
		return (T) this;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "time-since-reset")
	public Long timeSinceReset() {
		return this.timeSinceReset;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T timeSinceReset(Long value) {
		this.timeSinceReset = value;
		return (T) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@Subresource
	public ComponentEviction componentEviction() {
		return this.componentEviction;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T componentEviction(ComponentEviction value) {
		this.componentEviction = value;
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@Subresource
	public ComponentExpiration componentExpiration() {
		return this.componentExpiration;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T componentExpiration(ComponentExpiration value) {
		this.componentExpiration = value;
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@Subresource
	public StoreCustom storeCustom() {
		return this.storeCustom;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeCustom(StoreCustom value) {
		this.storeCustom = value;
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@Subresource
	public StoreNone storeNone() {
		return this.storeNone;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeNone(StoreNone value) {
		this.storeNone = value;
		return (T) this;
	}

	/**
	 * A cache for which this cache acts as a backup (for use with cross site replication).
	 */
	@Subresource
	public ComponentBackupFor componentBackupFor() {
		return this.componentBackupFor;
	}

	/**
	 * A cache for which this cache acts as a backup (for use with cross site replication).
	 */
	@SuppressWarnings("unchecked")
	public T componentBackupFor(ComponentBackupFor value) {
		this.componentBackupFor = value;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@Subresource
	public ComponentTransaction componentTransaction() {
		return this.componentTransaction;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T componentTransaction(ComponentTransaction value) {
		this.componentTransaction = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public StoreBinaryJdbc storeBinaryJdbc() {
		return this.storeBinaryJdbc;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeBinaryJdbc(StoreBinaryJdbc value) {
		this.storeBinaryJdbc = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public StoreStringJdbc storeStringJdbc() {
		return this.storeStringJdbc;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeStringJdbc(StoreStringJdbc value) {
		this.storeStringJdbc = value;
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@Subresource
	public StoreFile storeFile() {
		return this.storeFile;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeFile(StoreFile value) {
		this.storeFile = value;
		return (T) this;
	}

	/**
	 * The state transfer configuration for distributed and replicated caches.
	 */
	@Subresource
	public ComponentStateTransfer componentStateTransfer() {
		return this.componentStateTransfer;
	}

	/**
	 * The state transfer configuration for distributed and replicated caches.
	 */
	@SuppressWarnings("unchecked")
	public T componentStateTransfer(ComponentStateTransfer value) {
		this.componentStateTransfer = value;
		return (T) this;
	}

	/**
	 * The partition handling configuration for distributed and replicated caches.
	 */
	@Subresource
	public ComponentPartitionHandling componentPartitionHandling() {
		return this.componentPartitionHandling;
	}

	/**
	 * The partition handling configuration for distributed and replicated caches.
	 */
	@SuppressWarnings("unchecked")
	public T componentPartitionHandling(ComponentPartitionHandling value) {
		this.componentPartitionHandling = value;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@Subresource
	public ComponentLocking componentLocking() {
		return this.componentLocking;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T componentLocking(ComponentLocking value) {
		this.componentLocking = value;
		return (T) this;
	}

	/**
	 * The remote backups for this cache.
	 */
	@Subresource
	public ComponentBackups componentBackups() {
		return this.componentBackups;
	}

	/**
	 * The remote backups for this cache.
	 */
	@SuppressWarnings("unchecked")
	public T componentBackups(ComponentBackups value) {
		this.componentBackups = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public StoreMixedJdbc storeMixedJdbc() {
		return this.storeMixedJdbc;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeMixedJdbc(StoreMixedJdbc value) {
		this.storeMixedJdbc = value;
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@Subresource
	public StoreRemote storeRemote() {
		return this.storeRemote;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeRemote(StoreRemote value) {
		this.storeRemote = value;
		return (T) this;
	}
}