package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.ComponentEviction;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.StoreStringJdbc;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.StoreCustom;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.ComponentExpiration;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.StoreFile;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.StoreNone;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.ComponentTransaction;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.ComponentLocking;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.StoreBinaryJdbc;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.StoreMixedJdbc;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.StoreRemote;
/**
 * A local cache configuration
 */
@Address("/subsystem=infinispan/cache-container=*/local-cache=*")
public class LocalCache<T extends LocalCache> {

	private String key;
	private Long activations;
	private Long averageReadTime;
	private Long averageWriteTime;
	private String cacheStatus;
	private Long elapsedTime;
	private Double hitRatio;
	private Long hits;
	private Long invalidations;
	private String jndiName;
	private Long misses;
	private String module;
	private Integer numberOfEntries;
	private Long passivations;
	private Double readWriteRatio;
	private Long removeHits;
	private Long removeMisses;
	private Boolean statisticsEnabled;
	private Long stores;
	private Long timeSinceReset;
	private ComponentEviction componentEviction;
	private StoreStringJdbc storeStringJdbc;
	private StoreCustom storeCustom;
	private ComponentExpiration componentExpiration;
	private StoreFile storeFile;
	private StoreNone storeNone;
	private ComponentTransaction componentTransaction;
	private ComponentLocking componentLocking;
	private StoreBinaryJdbc storeBinaryJdbc;
	private StoreMixedJdbc storeMixedJdbc;
	private StoreRemote storeRemote;

	public LocalCache(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "activations")
	public Long activations() {
		return this.activations;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T activations(Long value) {
		this.activations = value;
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-read-time")
	public Long averageReadTime() {
		return this.averageReadTime;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageReadTime(Long value) {
		this.averageReadTime = value;
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-write-time")
	public Long averageWriteTime() {
		return this.averageWriteTime;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageWriteTime(Long value) {
		this.averageWriteTime = value;
		return (T) this;
	}

	/**
	 * The status of the cache component. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-status")
	public String cacheStatus() {
		return this.cacheStatus;
	}

	/**
	 * The status of the cache component. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T cacheStatus(String value) {
		this.cacheStatus = value;
		return (T) this;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "elapsed-time")
	public Long elapsedTime() {
		return this.elapsedTime;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T elapsedTime(Long value) {
		this.elapsedTime = value;
		return (T) this;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hit-ratio")
	public Double hitRatio() {
		return this.hitRatio;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T hitRatio(Double value) {
		this.hitRatio = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hits")
	public Long hits() {
		return this.hits;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T hits(Long value) {
		this.hits = value;
		return (T) this;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "invalidations")
	public Long invalidations() {
		return this.invalidations;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T invalidations(Long value) {
		this.invalidations = value;
		return (T) this;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		this.jndiName = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "misses")
	public Long misses() {
		return this.misses;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T misses(Long value) {
		this.misses = value;
		return (T) this;
	}

	/**
	 * The module whose class loader should be used when building this cache's configuration.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module whose class loader should be used when building this cache's configuration.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		this.module = value;
		return (T) this;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-entries")
	public Integer numberOfEntries() {
		return this.numberOfEntries;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfEntries(Integer value) {
		this.numberOfEntries = value;
		return (T) this;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "passivations")
	public Long passivations() {
		return this.passivations;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T passivations(Long value) {
		this.passivations = value;
		return (T) this;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "read-write-ratio")
	public Double readWriteRatio() {
		return this.readWriteRatio;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T readWriteRatio(Double value) {
		this.readWriteRatio = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-hits")
	public Long removeHits() {
		return this.removeHits;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T removeHits(Long value) {
		this.removeHits = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-misses")
	public Long removeMisses() {
		return this.removeMisses;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T removeMisses(Long value) {
		this.removeMisses = value;
		return (T) this;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(Boolean value) {
		this.statisticsEnabled = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute put operations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "stores")
	public Long stores() {
		return this.stores;
	}

	/**
	 * The number of cache attribute put operations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T stores(Long value) {
		this.stores = value;
		return (T) this;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "time-since-reset")
	public Long timeSinceReset() {
		return this.timeSinceReset;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T timeSinceReset(Long value) {
		this.timeSinceReset = value;
		return (T) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@Subresource
	public ComponentEviction componentEviction() {
		return this.componentEviction;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T componentEviction(ComponentEviction value) {
		this.componentEviction = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public StoreStringJdbc storeStringJdbc() {
		return this.storeStringJdbc;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeStringJdbc(StoreStringJdbc value) {
		this.storeStringJdbc = value;
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@Subresource
	public StoreCustom storeCustom() {
		return this.storeCustom;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeCustom(StoreCustom value) {
		this.storeCustom = value;
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@Subresource
	public ComponentExpiration componentExpiration() {
		return this.componentExpiration;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T componentExpiration(ComponentExpiration value) {
		this.componentExpiration = value;
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@Subresource
	public StoreFile storeFile() {
		return this.storeFile;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeFile(StoreFile value) {
		this.storeFile = value;
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@Subresource
	public StoreNone storeNone() {
		return this.storeNone;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeNone(StoreNone value) {
		this.storeNone = value;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@Subresource
	public ComponentTransaction componentTransaction() {
		return this.componentTransaction;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T componentTransaction(ComponentTransaction value) {
		this.componentTransaction = value;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@Subresource
	public ComponentLocking componentLocking() {
		return this.componentLocking;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T componentLocking(ComponentLocking value) {
		this.componentLocking = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public StoreBinaryJdbc storeBinaryJdbc() {
		return this.storeBinaryJdbc;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeBinaryJdbc(StoreBinaryJdbc value) {
		this.storeBinaryJdbc = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public StoreMixedJdbc storeMixedJdbc() {
		return this.storeMixedJdbc;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeMixedJdbc(StoreMixedJdbc value) {
		this.storeMixedJdbc = value;
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@Subresource
	public StoreRemote storeRemote() {
		return this.storeRemote;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T storeRemote(StoreRemote value) {
		this.storeRemote = value;
		return (T) this;
	}
}