package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.replicatedCache;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The partition handling configuration for distributed and replicated caches.
 */
@Address("/subsystem=infinispan/cache-container=*/replicated-cache=*/component=partition-handling")
@Implicit
public class ComponentPartitionHandling<T extends ComponentPartitionHandling> {

	private String key;
	private String availability;
	private Boolean enabled;

	public ComponentPartitionHandling() {
		this.key = "partition-handling";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Indicates the current availability of the cache.
	 */
	@ModelNodeBinding(detypedName = "availability")
	public String availability() {
		return this.availability;
	}

	/**
	 * Indicates the current availability of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T availability(String value) {
		this.availability = value;
		return (T) this;
	}

	/**
	 * If enabled, the cache will enter degraded mode upon detecting a network partition that threatens the integrity of the cache.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * If enabled, the cache will enter degraded mode upon detecting a network partition that threatens the integrity of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		this.enabled = value;
		return (T) this;
	}
}