package org.wildfly.swarm.config.infinispan.subsystem.infinispan.cacheContainer.localCache.store.binaryJdbc.table;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Defines a table used to store cache entries whose keys cannot be expressed as strings.
 */
@Address("/subsystem=infinispan/cache-container=*/local-cache=*/store=binary-jdbc/table=binary")
@Implicit
public class TableBinary<T extends TableBinary> {

	private String key;
	private Integer batchSize;
	private Map dataColumn;
	private Integer fetchSize;
	private Map idColumn;
	private String prefix;
	private Map timestampColumn;

	public TableBinary() {
		this.key = "binary";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * For DB inserts, the batch size determines how many inserts are batched together.
	 */
	@ModelNodeBinding(detypedName = "batch-size")
	public Integer batchSize() {
		return this.batchSize;
	}

	/**
	 * For DB inserts, the batch size determines how many inserts are batched together.
	 */
	@SuppressWarnings("unchecked")
	public T batchSize(Integer value) {
		this.batchSize = value;
		return (T) this;
	}

	/**
	 * A database column to hold cache entry data.
	 */
	@ModelNodeBinding(detypedName = "data-column")
	public Map dataColumn() {
		return this.dataColumn;
	}

	/**
	 * A database column to hold cache entry data.
	 */
	@SuppressWarnings("unchecked")
	public T dataColumn(Map value) {
		this.dataColumn = value;
		return (T) this;
	}

	/**
	 * For DB queries, the fetch size will be used to set the fetch size on ResultSets.
	 */
	@ModelNodeBinding(detypedName = "fetch-size")
	public Integer fetchSize() {
		return this.fetchSize;
	}

	/**
	 * For DB queries, the fetch size will be used to set the fetch size on ResultSets.
	 */
	@SuppressWarnings("unchecked")
	public T fetchSize(Integer value) {
		this.fetchSize = value;
		return (T) this;
	}

	/**
	 * A database column to hold cache entry ids.
	 */
	@ModelNodeBinding(detypedName = "id-column")
	public Map idColumn() {
		return this.idColumn;
	}

	/**
	 * A database column to hold cache entry ids.
	 */
	@SuppressWarnings("unchecked")
	public T idColumn(Map value) {
		this.idColumn = value;
		return (T) this;
	}

	/**
	 * The prefix for the database table name.
	 */
	@ModelNodeBinding(detypedName = "prefix")
	public String prefix() {
		return this.prefix;
	}

	/**
	 * The prefix for the database table name.
	 */
	@SuppressWarnings("unchecked")
	public T prefix(String value) {
		this.prefix = value;
		return (T) this;
	}

	/**
	 * A database column to hold cache entry timestamps.
	 */
	@ModelNodeBinding(detypedName = "timestamp-column")
	public Map timestampColumn() {
		return this.timestampColumn;
	}

	/**
	 * A database column to hold cache entry timestamps.
	 */
	@SuppressWarnings("unchecked")
	public T timestampColumn(Map value) {
		this.timestampColumn = value;
		return (T) this;
	}
}