package org.wildfly.swarm.config.jca.subsystem;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Bean validation (JSR-303) for resource adapters
 */
@Address("/subsystem=jca/bean-validation=bean-validation")
@Implicit
public class SubsystemBeanValidation<T extends SubsystemBeanValidation> {

	private String key;
	private Boolean enabled;

	public SubsystemBeanValidation() {
		this.key = "bean-validation";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Specify whether bean validation is enabled
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Specify whether bean validation is enabled
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		this.enabled = value;
		return (T) this;
	}
}