package org.wildfly.swarm.config.jca.subsystem;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Tracer for resource adapters
 */
@Address("/subsystem=jca/tracer=tracer")
@Implicit
public class SubsystemTracer<T extends SubsystemTracer> {

	private String key;
	private Boolean enabled;

	public SubsystemTracer() {
		this.key = "tracer";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Specify whether tracer is enabled
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Specify whether tracer is enabled
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		this.enabled = value;
		return (T) this;
	}
}