package org.wildfly.swarm.config.messaging.subsystem.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@Address("/subsystem=messaging-activemq/server=*/ha-policy=live-only")
@Implicit
public class HaPolicyLiveOnly<T extends HaPolicyLiveOnly> {

	private String key;
	private Boolean scaleDown;
	private String scaleDownClusterName;
	private List<String> scaleDownConnectors;
	private String scaleDownDiscoveryGroup;
	private String scaleDownGroupName;

	public HaPolicyLiveOnly() {
		this.key = "live-only";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Configure whether this server send its messages to another live server in the scale-down cluster when it is shutdown cleanly.
	 */
	@ModelNodeBinding(detypedName = "scale-down")
	public Boolean scaleDown() {
		return this.scaleDown;
	}

	/**
	 * Configure whether this server send its messages to another live server in the scale-down cluster when it is shutdown cleanly.
	 */
	@SuppressWarnings("unchecked")
	public T scaleDown(Boolean value) {
		this.scaleDown = value;
		return (T) this;
	}

	/**
	 * Name of the cluster used to scale down.
	 */
	@ModelNodeBinding(detypedName = "scale-down-cluster-name")
	public String scaleDownClusterName() {
		return this.scaleDownClusterName;
	}

	/**
	 * Name of the cluster used to scale down.
	 */
	@SuppressWarnings("unchecked")
	public T scaleDownClusterName(String value) {
		this.scaleDownClusterName = value;
		return (T) this;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	@ModelNodeBinding(detypedName = "scale-down-connectors")
	public List<String> scaleDownConnectors() {
		return this.scaleDownConnectors;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	@SuppressWarnings("unchecked")
	public T scaleDownConnectors(List<String> value) {
		this.scaleDownConnectors = value;
		return (T) this;
	}

	/**
	 * Name of the discovery group used to build the scale-down cluster
	 */
	@ModelNodeBinding(detypedName = "scale-down-discovery-group")
	public String scaleDownDiscoveryGroup() {
		return this.scaleDownDiscoveryGroup;
	}

	/**
	 * Name of the discovery group used to build the scale-down cluster
	 */
	@SuppressWarnings("unchecked")
	public T scaleDownDiscoveryGroup(String value) {
		this.scaleDownDiscoveryGroup = value;
		return (T) this;
	}

	/**
	 * Name of the group used to scale down.
	 */
	@ModelNodeBinding(detypedName = "scale-down-group-name")
	public String scaleDownGroupName() {
		return this.scaleDownGroupName;
	}

	/**
	 * Name of the group used to scale down.
	 */
	@SuppressWarnings("unchecked")
	public T scaleDownGroupName(String value) {
		this.scaleDownGroupName = value;
		return (T) this;
	}
}