package org.wildfly.swarm.config.messaging.subsystem.server.acceptor;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * An acceptor defines a way in which connections can be made to the ActiveMQ server.
 */
@Address("/subsystem=messaging-activemq/server=*/acceptor=*")
public class Acceptor<T extends Acceptor> {

	private String key;
	private String factoryClass;
	private Map params;
	private String socketBinding;
	private Boolean started;

	public Acceptor(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the factory class that can instantiate the acceptor.
	 */
	@ModelNodeBinding(detypedName = "factory-class")
	public String factoryClass() {
		return this.factoryClass;
	}

	/**
	 * Class name of the factory class that can instantiate the acceptor.
	 */
	@SuppressWarnings("unchecked")
	public T factoryClass(String value) {
		this.factoryClass = value;
		return (T) this;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	@SuppressWarnings("unchecked")
	public T params(Map value) {
		this.params = value;
		return (T) this;
	}

	/**
	 * The socket binding that the acceptor will use to accept connections.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The socket binding that the acceptor will use to accept connections.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(String value) {
		this.socketBinding = value;
		return (T) this;
	}

	/**
	 * Whether this acceptor is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether this acceptor is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(Boolean value) {
		this.started = value;
		return (T) this;
	}
}