package org.wildfly.swarm.config.messaging.subsystem.server.connectorService;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * TODO
 */
@Address("/subsystem=messaging-activemq/server=*/connector-service=*")
public class ConnectorService<T extends ConnectorService> {

	private String key;
	private String factoryClass;
	private Map params;

	public ConnectorService(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the factory class that can instantiate the connector service.
	 */
	@ModelNodeBinding(detypedName = "factory-class")
	public String factoryClass() {
		return this.factoryClass;
	}

	/**
	 * Class name of the factory class that can instantiate the connector service.
	 */
	@SuppressWarnings("unchecked")
	public T factoryClass(String value) {
		this.factoryClass = value;
		return (T) this;
	}

	/**
	 * A key/value pair understood by the connector service's factory-class
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key/value pair understood by the connector service's factory-class
	 */
	@SuppressWarnings("unchecked")
	public T params(Map value) {
		this.params = value;
		return (T) this;
	}
}