package org.wildfly.swarm.config.messaging.subsystem.server.coreAddress.role;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A security role.
 */
@Address("/subsystem=messaging-activemq/server=*/core-address=*/role=*")
public class Role<T extends Role> {

	private String key;
	private Boolean consume;
	private Boolean createDurableQueue;
	private Boolean createNonDurableQueue;
	private Boolean deleteDurableQueue;
	private Boolean deleteNonDurableQueue;
	private Boolean manage;
	private Boolean send;

	public Role(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * his permission allows the user to consume a message from a queue bound to matching addresses.
	 */
	@ModelNodeBinding(detypedName = "consume")
	public Boolean consume() {
		return this.consume;
	}

	/**
	 * his permission allows the user to consume a message from a queue bound to matching addresses.
	 */
	@SuppressWarnings("unchecked")
	public T consume(Boolean value) {
		this.consume = value;
		return (T) this;
	}

	/**
	 * This permission allows the user to create a durable queue.
	 */
	@ModelNodeBinding(detypedName = "create-durable-queue")
	public Boolean createDurableQueue() {
		return this.createDurableQueue;
	}

	/**
	 * This permission allows the user to create a durable queue.
	 */
	@SuppressWarnings("unchecked")
	public T createDurableQueue(Boolean value) {
		this.createDurableQueue = value;
		return (T) this;
	}

	/**
	 * This permission allows the user to create a temporary queue.
	 */
	@ModelNodeBinding(detypedName = "create-non-durable-queue")
	public Boolean createNonDurableQueue() {
		return this.createNonDurableQueue;
	}

	/**
	 * This permission allows the user to create a temporary queue.
	 */
	@SuppressWarnings("unchecked")
	public T createNonDurableQueue(Boolean value) {
		this.createNonDurableQueue = value;
		return (T) this;
	}

	/**
	 * This permission allows the user to delete a durable queue.
	 */
	@ModelNodeBinding(detypedName = "delete-durable-queue")
	public Boolean deleteDurableQueue() {
		return this.deleteDurableQueue;
	}

	/**
	 * This permission allows the user to delete a durable queue.
	 */
	@SuppressWarnings("unchecked")
	public T deleteDurableQueue(Boolean value) {
		this.deleteDurableQueue = value;
		return (T) this;
	}

	/**
	 * This permission allows the user to delete a temporary queue.
	 */
	@ModelNodeBinding(detypedName = "delete-non-durable-queue")
	public Boolean deleteNonDurableQueue() {
		return this.deleteNonDurableQueue;
	}

	/**
	 * This permission allows the user to delete a temporary queue.
	 */
	@SuppressWarnings("unchecked")
	public T deleteNonDurableQueue(Boolean value) {
		this.deleteNonDurableQueue = value;
		return (T) this;
	}

	/**
	 * This permission allows the user to invoke management operations by sending management messages to the management address.
	 */
	@ModelNodeBinding(detypedName = "manage")
	public Boolean manage() {
		return this.manage;
	}

	/**
	 * This permission allows the user to invoke management operations by sending management messages to the management address.
	 */
	@SuppressWarnings("unchecked")
	public T manage(Boolean value) {
		this.manage = value;
		return (T) this;
	}

	/**
	 * This permission allows the user to send a message to matching addresses.
	 */
	@ModelNodeBinding(detypedName = "send")
	public Boolean send() {
		return this.send;
	}

	/**
	 * This permission allows the user to send a message to matching addresses.
	 */
	@SuppressWarnings("unchecked")
	public T send(Boolean value) {
		this.send = value;
		return (T) this;
	}
}