package org.wildfly.swarm.config.messaging.subsystem.server.remoteConnector;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Used by a remote client to define how it connects to a server.
 */
@Address("/subsystem=messaging-activemq/server=*/remote-connector=*")
public class RemoteConnector<T extends RemoteConnector> {

	private String key;
	private Map params;
	private String socketBinding;

	public RemoteConnector(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to configure it.
	 */
	@SuppressWarnings("unchecked")
	public T params(Map value) {
		this.params = value;
		return (T) this;
	}

	/**
	 * The socket binding that the connector will use to create connections.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The socket binding that the connector will use to create connections.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(String value) {
		this.socketBinding = value;
		return (T) this;
	}
}