package org.wildfly.swarm.config.remoting.subsystem.httpConnector;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.subsystem.httpConnector.property.Property;
import org.wildfly.swarm.config.remoting.subsystem.httpConnector.SecuritySasl;
/**
 * The configuration of a HTTP Upgrade based Remoting connector.
 */
@Address("/subsystem=remoting/http-connector=*")
public class HttpConnector<T extends HttpConnector> {

	private String key;
	private String authenticationProvider;
	private String connectorRef;
	private String saslProtocol;
	private String securityRealm;
	private String serverName;
	private HttpConnectorResources subresources = new HttpConnectorResources();
	private SecuritySasl securitySasl;

	public HttpConnector(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The "authentication-provider" element contains the name of the authentication provider to use for incoming connections.
	 */
	@ModelNodeBinding(detypedName = "authentication-provider")
	public String authenticationProvider() {
		return this.authenticationProvider;
	}

	/**
	 * The "authentication-provider" element contains the name of the authentication provider to use for incoming connections.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationProvider(String value) {
		this.authenticationProvider = value;
		return (T) this;
	}

	/**
	 * The name (or names) of a connector in the Undertow subsystem to connect to.
	 */
	@ModelNodeBinding(detypedName = "connector-ref")
	public String connectorRef() {
		return this.connectorRef;
	}

	/**
	 * The name (or names) of a connector in the Undertow subsystem to connect to.
	 */
	@SuppressWarnings("unchecked")
	public T connectorRef(String value) {
		this.connectorRef = value;
		return (T) this;
	}

	/**
	 * The protocol to pass into the SASL mechanisms used for authentication.
	 */
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * The protocol to pass into the SASL mechanisms used for authentication.
	 */
	@SuppressWarnings("unchecked")
	public T saslProtocol(String value) {
		this.saslProtocol = value;
		return (T) this;
	}

	/**
	 * The associated security realm to use for authentication for this connector.
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The associated security realm to use for authentication for this connector.
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(String value) {
		this.securityRealm = value;
		return (T) this;
	}

	/**
	 * The server name to send in the initial message exchange and for SASL based authentication.
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The server name to send in the initial message exchange and for SASL based authentication.
	 */
	@SuppressWarnings("unchecked")
	public T serverName(String value) {
		this.serverName = value;
		return (T) this;
	}

	public HttpConnectorResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Property objects to this subresource
	 * @return this
	 * @param value List of Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T propertys(List<Property> value) {
		this.subresources.propertys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Property object to the list of subresources
	 * @param value The Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.propertys.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for HttpConnector
	 */
	public class HttpConnectorResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}

	/**
	 * The "sasl" element contains the SASL authentication configuration for this connector.
	 */
	@Subresource
	public SecuritySasl securitySasl() {
		return this.securitySasl;
	}

	/**
	 * The "sasl" element contains the SASL authentication configuration for this connector.
	 */
	@SuppressWarnings("unchecked")
	public T securitySasl(SecuritySasl value) {
		this.securitySasl = value;
		return (T) this;
	}
}