package org.wildfly.swarm.config.security.subsystem.securityDomain;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.subsystem.securityDomain.acl.aclModule.AclModule;
/**
 * Access control list configuration. Configures a list of ACL modules to be used.
 */
@Address("/subsystem=security/security-domain=*/acl=classic")
@Implicit
public class AclClassic<T extends AclClassic> {

	private String key;
	private AclClassicResources subresources = new AclClassicResources();

	public AclClassic() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public AclClassicResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all AclModule objects to this subresource
	 * @return this
	 * @param value List of AclModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T aclModules(List<AclModule> value) {
		this.subresources.aclModules.addAll(value);
		return (T) this;
	}

	/**
	 * Add the AclModule object to the list of subresources
	 * @param value The AclModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aclModule(AclModule value) {
		this.subresources.aclModules.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for AclClassic
	 */
	public class AclClassicResources {
		/**
		 * List of authentication modules
		 */
		private List<AclModule> aclModules = new java.util.ArrayList<>();

		/**
		 * Get the list of AclModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AclModule> aclModules() {
			return this.aclModules;
		}
	}
}