package org.wildfly.swarm.config.security.subsystem.securityDomain;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.subsystem.securityDomain.authentication.loginModule.LoginModule;
/**
 * Traditional authentication configuration.  Configures a list of login modules to be used.
 */
@Address("/subsystem=security/security-domain=*/authentication=classic")
@Implicit
public class AuthenticationClassic<T extends AuthenticationClassic> {

	private String key;
	private AuthenticationClassicResources subresources = new AuthenticationClassicResources();

	public AuthenticationClassic() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public AuthenticationClassicResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all LoginModule objects to this subresource
	 * @return this
	 * @param value List of LoginModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T loginModules(List<LoginModule> value) {
		this.subresources.loginModules.addAll(value);
		return (T) this;
	}

	/**
	 * Add the LoginModule object to the list of subresources
	 * @param value The LoginModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loginModule(LoginModule value) {
		this.subresources.loginModules.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for AuthenticationClassic
	 */
	public class AuthenticationClassicResources {
		/**
		 * List of authentication modules
		 */
		private List<LoginModule> loginModules = new java.util.ArrayList<>();

		/**
		 * Get the list of LoginModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LoginModule> loginModules() {
			return this.loginModules;
		}
	}
}