package org.wildfly.swarm.config.security.subsystem.securityDomain;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.subsystem.securityDomain.authorization.policyModule.PolicyModule;
/**
 * Authorization configuration. Configures a list of authorization policy modules to be used.
 */
@Address("/subsystem=security/security-domain=*/authorization=classic")
@Implicit
public class AuthorizationClassic<T extends AuthorizationClassic> {

	private String key;
	private AuthorizationClassicResources subresources = new AuthorizationClassicResources();

	public AuthorizationClassic() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public AuthorizationClassicResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all PolicyModule objects to this subresource
	 * @return this
	 * @param value List of PolicyModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T policyModules(List<PolicyModule> value) {
		this.subresources.policyModules.addAll(value);
		return (T) this;
	}

	/**
	 * Add the PolicyModule object to the list of subresources
	 * @param value The PolicyModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T policyModule(PolicyModule value) {
		this.subresources.policyModules.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for AuthorizationClassic
	 */
	public class AuthorizationClassicResources {
		/**
		 * List of authentication modules
		 */
		private List<PolicyModule> policyModules = new java.util.ArrayList<>();

		/**
		 * Get the list of PolicyModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<PolicyModule> policyModules() {
			return this.policyModules;
		}
	}
}