package org.wildfly.swarm.config.security.subsystem.securityDomain;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.subsystem.securityDomain.identityTrust.trustModule.TrustModule;
/**
 * Identity trust configuration. Configures a list of trust modules to be used.
 */
@Address("/subsystem=security/security-domain=*/identity-trust=classic")
@Implicit
public class IdentityTrustClassic<T extends IdentityTrustClassic> {

	private String key;
	private IdentityTrustClassicResources subresources = new IdentityTrustClassicResources();

	public IdentityTrustClassic() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public IdentityTrustClassicResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all TrustModule objects to this subresource
	 * @return this
	 * @param value List of TrustModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T trustModules(List<TrustModule> value) {
		this.subresources.trustModules.addAll(value);
		return (T) this;
	}

	/**
	 * Add the TrustModule object to the list of subresources
	 * @param value The TrustModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T trustModule(TrustModule value) {
		this.subresources.trustModules.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for IdentityTrustClassic
	 */
	public class IdentityTrustClassicResources {
		/**
		 * List of authentication modules
		 */
		private List<TrustModule> trustModules = new java.util.ArrayList<>();

		/**
		 * Get the list of TrustModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<TrustModule> trustModules() {
			return this.trustModules;
		}
	}
}