package org.wildfly.swarm.config.security.subsystem.securityDomain;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.subsystem.securityDomain.JsseClassic;
import org.wildfly.swarm.config.security.subsystem.securityDomain.AuthorizationClassic;
import org.wildfly.swarm.config.security.subsystem.securityDomain.AuditClassic;
import org.wildfly.swarm.config.security.subsystem.securityDomain.AclClassic;
import org.wildfly.swarm.config.security.subsystem.securityDomain.AuthenticationJaspi;
import org.wildfly.swarm.config.security.subsystem.securityDomain.MappingClassic;
import org.wildfly.swarm.config.security.subsystem.securityDomain.IdentityTrustClassic;
import org.wildfly.swarm.config.security.subsystem.securityDomain.AuthenticationClassic;
/**
 * Configures a security domain. Authentication, authorization, ACL, mapping, auditing and identity trust are configured here.
 */
@Address("/subsystem=security/security-domain=*")
public class SecurityDomain<T extends SecurityDomain> {

	private String key;
	private String cacheType;
	private JsseClassic jsseClassic;
	private AuthorizationClassic authorizationClassic;
	private AuditClassic auditClassic;
	private AclClassic aclClassic;
	private AuthenticationJaspi authenticationJaspi;
	private MappingClassic mappingClassic;
	private IdentityTrustClassic identityTrustClassic;
	private AuthenticationClassic authenticationClassic;

	public SecurityDomain(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a cache to speed up authentication checks. Allowed values are 'default' to use simple map as the cache and 'infinispan' to use an Infinispan cache.
	 */
	@ModelNodeBinding(detypedName = "cache-type")
	public String cacheType() {
		return this.cacheType;
	}

	/**
	 * Adds a cache to speed up authentication checks. Allowed values are 'default' to use simple map as the cache and 'infinispan' to use an Infinispan cache.
	 */
	@SuppressWarnings("unchecked")
	public T cacheType(String value) {
		this.cacheType = value;
		return (T) this;
	}

	/**
	 * JSSE configuration. Configures attributes for keystores that can be used for setting up SSL.
	 */
	@Subresource
	public JsseClassic jsseClassic() {
		return this.jsseClassic;
	}

	/**
	 * JSSE configuration. Configures attributes for keystores that can be used for setting up SSL.
	 */
	@SuppressWarnings("unchecked")
	public T jsseClassic(JsseClassic value) {
		this.jsseClassic = value;
		return (T) this;
	}

	/**
	 * Authorization configuration. Configures a list of authorization policy modules to be used.
	 */
	@Subresource
	public AuthorizationClassic authorizationClassic() {
		return this.authorizationClassic;
	}

	/**
	 * Authorization configuration. Configures a list of authorization policy modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T authorizationClassic(AuthorizationClassic value) {
		this.authorizationClassic = value;
		return (T) this;
	}

	/**
	 * Auditing configuration. Configures a list of provider modules to be used.
	 */
	@Subresource
	public AuditClassic auditClassic() {
		return this.auditClassic;
	}

	/**
	 * Auditing configuration. Configures a list of provider modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T auditClassic(AuditClassic value) {
		this.auditClassic = value;
		return (T) this;
	}

	/**
	 * Access control list configuration. Configures a list of ACL modules to be used.
	 */
	@Subresource
	public AclClassic aclClassic() {
		return this.aclClassic;
	}

	/**
	 * Access control list configuration. Configures a list of ACL modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T aclClassic(AclClassic value) {
		this.aclClassic = value;
		return (T) this;
	}

	/**
	 * JASPI authentication configuration.
	 */
	@Subresource
	public AuthenticationJaspi authenticationJaspi() {
		return this.authenticationJaspi;
	}

	/**
	 * JASPI authentication configuration.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationJaspi(AuthenticationJaspi value) {
		this.authenticationJaspi = value;
		return (T) this;
	}

	/**
	 * Mapping configuration. Configures a list of mapping modules to be used for principal, role, attribute and credential mapping.
	 */
	@Subresource
	public MappingClassic mappingClassic() {
		return this.mappingClassic;
	}

	/**
	 * Mapping configuration. Configures a list of mapping modules to be used for principal, role, attribute and credential mapping.
	 */
	@SuppressWarnings("unchecked")
	public T mappingClassic(MappingClassic value) {
		this.mappingClassic = value;
		return (T) this;
	}

	/**
	 * Identity trust configuration. Configures a list of trust modules to be used.
	 */
	@Subresource
	public IdentityTrustClassic identityTrustClassic() {
		return this.identityTrustClassic;
	}

	/**
	 * Identity trust configuration. Configures a list of trust modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T identityTrustClassic(IdentityTrustClassic value) {
		this.identityTrustClassic = value;
		return (T) this;
	}

	/**
	 * Traditional authentication configuration.  Configures a list of login modules to be used.
	 */
	@Subresource
	public AuthenticationClassic authenticationClassic() {
		return this.authenticationClassic;
	}

	/**
	 * Traditional authentication configuration.  Configures a list of login modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationClassic(AuthenticationClassic value) {
		this.authenticationClassic = value;
		return (T) this;
	}
}