package org.wildfly.swarm.config.security.subsystem.securityDomain.authentication.loginModuleStack;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.subsystem.security.securityDomain.authentication.jaspi.loginModuleStack.loginModule.LoginModule;
/**
 * List of "named" login modules that are used by jaspi authentication modules.
 */
@Address("/subsystem=security/security-domain=*/authentication=jaspi/login-module-stack=*")
public class LoginModuleStack<T extends LoginModuleStack> {

	private String key;
	private LoginModuleStackResources subresources = new LoginModuleStackResources();

	public LoginModuleStack(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	public LoginModuleStackResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all LoginModule objects to this subresource
	 * @return this
	 * @param value List of LoginModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T loginModules(List<LoginModule> value) {
		this.subresources.loginModules.addAll(value);
		return (T) this;
	}

	/**
	 * Add the LoginModule object to the list of subresources
	 * @param value The LoginModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loginModule(LoginModule value) {
		this.subresources.loginModules.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for LoginModuleStack
	 */
	public class LoginModuleStackResources {
		/**
		 * List of authentication modules
		 */
		private List<LoginModule> loginModules = new java.util.ArrayList<>();

		/**
		 * Get the list of LoginModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LoginModule> loginModules() {
			return this.loginModules;
		}
	}
}