package org.wildfly.swarm.config.undertow.subsystem.configuration.file;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * File handler
 */
@Address("/subsystem=undertow/configuration=handler/file=*")
public class File<T extends File> {

	private String key;
	private Long cacheBufferSize;
	private Long cacheBuffers;
	private Boolean caseSensitive;
	private Boolean directoryListing;
	private Boolean followSymlink;
	private String path;
	private List<String> safeSymlinkPaths;

	public File(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Size of the buffers
	 */
	@ModelNodeBinding(detypedName = "cache-buffer-size")
	public Long cacheBufferSize() {
		return this.cacheBufferSize;
	}

	/**
	 * Size of the buffers
	 */
	@SuppressWarnings("unchecked")
	public T cacheBufferSize(Long value) {
		this.cacheBufferSize = value;
		return (T) this;
	}

	/**
	 * Number of buffers
	 */
	@ModelNodeBinding(detypedName = "cache-buffers")
	public Long cacheBuffers() {
		return this.cacheBuffers;
	}

	/**
	 * Number of buffers
	 */
	@SuppressWarnings("unchecked")
	public T cacheBuffers(Long value) {
		this.cacheBuffers = value;
		return (T) this;
	}

	/**
	 * Use case sensitive file handling
	 */
	@ModelNodeBinding(detypedName = "case-sensitive")
	public Boolean caseSensitive() {
		return this.caseSensitive;
	}

	/**
	 * Use case sensitive file handling
	 */
	@SuppressWarnings("unchecked")
	public T caseSensitive(Boolean value) {
		this.caseSensitive = value;
		return (T) this;
	}

	/**
	 * Enable directory listing?
	 */
	@ModelNodeBinding(detypedName = "directory-listing")
	public Boolean directoryListing() {
		return this.directoryListing;
	}

	/**
	 * Enable directory listing?
	 */
	@SuppressWarnings("unchecked")
	public T directoryListing(Boolean value) {
		this.directoryListing = value;
		return (T) this;
	}

	/**
	 * Enable following symbolic links
	 */
	@ModelNodeBinding(detypedName = "follow-symlink")
	public Boolean followSymlink() {
		return this.followSymlink;
	}

	/**
	 * Enable following symbolic links
	 */
	@SuppressWarnings("unchecked")
	public T followSymlink(Boolean value) {
		this.followSymlink = value;
		return (T) this;
	}

	/**
	 * Path on filesystem from where file handler will serve resources
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Path on filesystem from where file handler will serve resources
	 */
	@SuppressWarnings("unchecked")
	public T path(String value) {
		this.path = value;
		return (T) this;
	}

	/**
	 * Paths that are safe to be targets of symbolic links
	 */
	@ModelNodeBinding(detypedName = "safe-symlink-paths")
	public List<String> safeSymlinkPaths() {
		return this.safeSymlinkPaths;
	}

	/**
	 * Paths that are safe to be targets of symbolic links
	 */
	@SuppressWarnings("unchecked")
	public T safeSymlinkPaths(List<String> value) {
		this.safeSymlinkPaths = value;
		return (T) this;
	}
}