package org.wildfly.swarm.config.undertow.subsystem.configuration.rewrite;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A rewrite (or redirect) filter
 */
@Address("/subsystem=undertow/configuration=filter/rewrite=*")
public class Rewrite<T extends Rewrite> {

	private String key;
	private Boolean redirect;
	private String target;

	public Rewrite(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If this is true then a redirect will be done instead of a rewrite
	 */
	@ModelNodeBinding(detypedName = "redirect")
	public Boolean redirect() {
		return this.redirect;
	}

	/**
	 * If this is true then a redirect will be done instead of a rewrite
	 */
	@SuppressWarnings("unchecked")
	public T redirect(Boolean value) {
		this.redirect = value;
		return (T) this;
	}

	/**
	 * The expression that defines the target. If you are redirecting to a constant target put single quotes around the value
	 */
	@ModelNodeBinding(detypedName = "target")
	public String target() {
		return this.target;
	}

	/**
	 * The expression that defines the target. If you are redirecting to a constant target put single quotes around the value
	 */
	@SuppressWarnings("unchecked")
	public T target(String value) {
		this.target = value;
		return (T) this;
	}
}