package org.wildfly.swarm.config;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.mail.MailSession;
/**
 * The mail subsystem
 */
@ResourceType("subsystem")
@Implicit
public class Mail<T extends Mail> {

	private String key;
	private MailResources subresources = new MailResources();

	public Mail() {
		this.key = "mail";
	}

	public String getKey() {
		return this.key;
	}

	public MailResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.mail.MailSession objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.mail.MailSession objects.
	 */
	@SuppressWarnings("unchecked")
	public T mailSessions(List<org.wildfly.swarm.config.mail.MailSession> value) {
		this.subresources.mailSessions.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.mail.MailSession object to the list of subresources
	 * @param value The org.wildfly.swarm.config.mail.MailSession to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mailSession(MailSession value) {
		this.subresources.mailSessions.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Mail
	 */
	public class MailResources {
		/**
		 * Mail session definition
		 */
		private List<org.wildfly.swarm.config.mail.MailSession> mailSessions = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.mail.MailSession resources
		 * @return the list of resources
		 */
		@Subresource
		public List<MailSession> mailSessions() {
			return this.mailSessions;
		}
	}
}