package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A cache store property with name and value.
 */
@ResourceType("property")
public class Property {

	private String key;
	private String value;

	public Property(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The value of the cache store property.
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The value of the cache store property.
	 */
	@SuppressWarnings("unchecked")
	public Property value(String value) {
		this.value = value;
		return (Property) this;
	}
}