package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Defines a thread pool used to execute remote commands.
 */
@ResourceType("thread-pool")
@Implicit
public class RemoteCommandThreadPool {

	private String key;
	private Long keepaliveTime;
	private Integer maxThreads;
	private Integer minThreads;
	private Integer queueLength;

	public RemoteCommandThreadPool() {
		this.key = "remote-command";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Long keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@SuppressWarnings("unchecked")
	public RemoteCommandThreadPool keepaliveTime(Long value) {
		this.keepaliveTime = value;
		return (RemoteCommandThreadPool) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public RemoteCommandThreadPool maxThreads(Integer value) {
		this.maxThreads = value;
		return (RemoteCommandThreadPool) this;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "min-threads")
	public Integer minThreads() {
		return this.minThreads;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public RemoteCommandThreadPool minThreads(Integer value) {
		this.minThreads = value;
		return (RemoteCommandThreadPool) this;
	}

	/**
	 * The queue length.
	 */
	@ModelNodeBinding(detypedName = "queue-length")
	public Integer queueLength() {
		return this.queueLength;
	}

	/**
	 * The queue length.
	 */
	@SuppressWarnings("unchecked")
	public RemoteCommandThreadPool queueLength(Integer value) {
		this.queueLength = value;
		return (RemoteCommandThreadPool) this;
	}
}