package org.wildfly.swarm.config.logging;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * Defines the root logger for this log context.
 */
@ResourceType("root-logger")
@Implicit
public class RootLogger {

	private String key;
	private String filterSpec;
	private List<String> handlers;
	private String level;

	public RootLogger() {
		this.key = "ROOT";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that does not match a pattern: not(match("JBAS.*"))
	 */
	@ModelNodeBinding(detypedName = "filter-spec")
	public String filterSpec() {
		return this.filterSpec;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that does not match a pattern: not(match("JBAS.*"))
	 */
	@SuppressWarnings("unchecked")
	public RootLogger filterSpec(String value) {
		this.filterSpec = value;
		return (RootLogger) this;
	}

	/**
	 * The handlers associated with the root logger.
	 */
	@ModelNodeBinding(detypedName = "handlers")
	public List<String> handlers() {
		return this.handlers;
	}

	/**
	 * The handlers associated with the root logger.
	 */
	@SuppressWarnings("unchecked")
	public RootLogger handlers(List<String> value) {
		this.handlers = value;
		return (RootLogger) this;
	}

	/**
	 * The log level specifying which message levels will be logged by the root logger. Message levels lower than this value will be discarded.
	 */
	@ModelNodeBinding(detypedName = "level")
	public String level() {
		return this.level;
	}

	/**
	 * The log level specifying which message levels will be logged by the root logger. Message levels lower than this value will be discarded.
	 */
	@SuppressWarnings("unchecked")
	public RootLogger level(String value) {
		this.level = value;
		return (RootLogger) this;
	}
}