package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Defines a way in which remote connections can be made to the ActiveMQ server over HTTP.
 */
@ResourceType("http-acceptor")
public class HttpAcceptor {

	private String key;
	private String httpListener;
	private Map params;
	private Boolean upgradeLegacy;

	public HttpAcceptor(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The Undertow's http-listener that handles HTTP upgrade requests.
	 */
	@ModelNodeBinding(detypedName = "http-listener")
	public String httpListener() {
		return this.httpListener;
	}

	/**
	 * The Undertow's http-listener that handles HTTP upgrade requests.
	 */
	@SuppressWarnings("unchecked")
	public HttpAcceptor httpListener(String value) {
		this.httpListener = value;
		return (HttpAcceptor) this;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	@SuppressWarnings("unchecked")
	public HttpAcceptor params(Map value) {
		this.params = value;
		return (HttpAcceptor) this;
	}

	/**
	 * Also accepts to upgrade HTTP request from legacy (HornetQ) clients.
	 */
	@ModelNodeBinding(detypedName = "upgrade-legacy")
	public Boolean upgradeLegacy() {
		return this.upgradeLegacy;
	}

	/**
	 * Also accepts to upgrade HTTP request from legacy (HornetQ) clients.
	 */
	@SuppressWarnings("unchecked")
	public HttpAcceptor upgradeLegacy(Boolean value) {
		this.upgradeLegacy = value;
		return (HttpAcceptor) this;
	}
}