package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Defines a way in which in-VM connections can be made to the ActiveMQ server.
 */
@ResourceType("in-vm-acceptor")
public class InVmAcceptor {

	private String key;
	private Map params;
	private Integer serverId;
	private Boolean started;

	public InVmAcceptor(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	@SuppressWarnings("unchecked")
	public InVmAcceptor params(Map value) {
		this.params = value;
		return (InVmAcceptor) this;
	}

	/**
	 * The server id.
	 */
	@ModelNodeBinding(detypedName = "server-id")
	public Integer serverId() {
		return this.serverId;
	}

	/**
	 * The server id.
	 */
	@SuppressWarnings("unchecked")
	public InVmAcceptor serverId(Integer value) {
		this.serverId = value;
		return (InVmAcceptor) this;
	}

	/**
	 * Whether this acceptor is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether this acceptor is started.
	 */
	@SuppressWarnings("unchecked")
	public InVmAcceptor started(Boolean value) {
		this.started = value;
		return (InVmAcceptor) this;
	}
}