package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging_activemq.server.ha_policy.shared_store_colocated.MasterConfiguration;
import org.wildfly.swarm.config.messaging_activemq.server.ha_policy.shared_store_colocated.SlaveConfiguration;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@ResourceType("ha-policy")
@Implicit
public class SharedStoreColocatedHaPolicy {

	private String key;
	private Integer backupPortOffset;
	private Integer backupRequestRetries;
	private Long backupRequestRetryInterval;
	private Integer maxBackups;
	private Boolean requestBackup;
	private MasterConfiguration masterConfiguration;
	private SlaveConfiguration slaveConfiguration;

	public SharedStoreColocatedHaPolicy() {
		this.key = "shared-store-colocated";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The offset to use for the Connectors and Acceptors when creating a new backup server.
	 */
	@ModelNodeBinding(detypedName = "backup-port-offset")
	public Integer backupPortOffset() {
		return this.backupPortOffset;
	}

	/**
	 * The offset to use for the Connectors and Acceptors when creating a new backup server.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreColocatedHaPolicy backupPortOffset(Integer value) {
		this.backupPortOffset = value;
		return (SharedStoreColocatedHaPolicy) this;
	}

	/**
	 * How many times the live server will try to request a backup, -1 means for ever.
	 */
	@ModelNodeBinding(detypedName = "backup-request-retries")
	public Integer backupRequestRetries() {
		return this.backupRequestRetries;
	}

	/**
	 * How many times the live server will try to request a backup, -1 means for ever.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreColocatedHaPolicy backupRequestRetries(Integer value) {
		this.backupRequestRetries = value;
		return (SharedStoreColocatedHaPolicy) this;
	}

	/**
	 * How long (in ms) to wait for retries between attempts to request a backup server.
	 */
	@ModelNodeBinding(detypedName = "backup-request-retry-interval")
	public Long backupRequestRetryInterval() {
		return this.backupRequestRetryInterval;
	}

	/**
	 * How long (in ms) to wait for retries between attempts to request a backup server.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreColocatedHaPolicy backupRequestRetryInterval(Long value) {
		this.backupRequestRetryInterval = value;
		return (SharedStoreColocatedHaPolicy) this;
	}

	/**
	 * Whether or not this live server will accept backup requests from other live servers.
	 */
	@ModelNodeBinding(detypedName = "max-backups")
	public Integer maxBackups() {
		return this.maxBackups;
	}

	/**
	 * Whether or not this live server will accept backup requests from other live servers.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreColocatedHaPolicy maxBackups(Integer value) {
		this.maxBackups = value;
		return (SharedStoreColocatedHaPolicy) this;
	}

	/**
	 * If true then the server will request a backup on another node.
	 */
	@ModelNodeBinding(detypedName = "request-backup")
	public Boolean requestBackup() {
		return this.requestBackup;
	}

	/**
	 * If true then the server will request a backup on another node.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreColocatedHaPolicy requestBackup(Boolean value) {
		this.requestBackup = value;
		return (SharedStoreColocatedHaPolicy) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public MasterConfiguration masterConfiguration() {
		return this.masterConfiguration;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreColocatedHaPolicy masterConfiguration(
			MasterConfiguration value) {
		this.masterConfiguration = value;
		return (SharedStoreColocatedHaPolicy) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public SlaveConfiguration slaveConfiguration() {
		return this.slaveConfiguration;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreColocatedHaPolicy slaveConfiguration(
			SlaveConfiguration value) {
		this.slaveConfiguration = value;
		return (SharedStoreColocatedHaPolicy) this;
	}
}