package org.wildfly.swarm.config.remoting;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
/**
 * Remoting outbound connection with an implicit local:// URI scheme.
 */
@ResourceType("local-outbound-connection")
public class LocalOutboundConnection {

	private String key;
	private String outboundSocketBindingRef;
	private LocalOutboundConnectionResources subresources = new LocalOutboundConnectionResources();

	public LocalOutboundConnection(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.
	 */
	@ModelNodeBinding(detypedName = "outbound-socket-binding-ref")
	public String outboundSocketBindingRef() {
		return this.outboundSocketBindingRef;
	}

	/**
	 * Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.
	 */
	@SuppressWarnings("unchecked")
	public LocalOutboundConnection outboundSocketBindingRef(String value) {
		this.outboundSocketBindingRef = value;
		return (LocalOutboundConnection) this;
	}

	public LocalOutboundConnectionResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.Property objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.Property objects.
	 */
	@SuppressWarnings("unchecked")
	public LocalOutboundConnection propertys(
			List<org.wildfly.swarm.config.remoting.Property> value) {
		this.subresources.propertys.addAll(value);
		return (LocalOutboundConnection) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.Property object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LocalOutboundConnection property(Property value) {
		this.subresources.propertys.add(value);
		return (LocalOutboundConnection) this;
	}

	/**
	 * Child mutators for LocalOutboundConnection
	 */
	public class LocalOutboundConnectionResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<org.wildfly.swarm.config.remoting.Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}
}