package org.wildfly.swarm.config.security.security_domain.authentication;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * List of modules that map principal, role, and credential information
 */
@ResourceType("auth-module")
public class AuthModule {

	private String key;
	private String code;
	private String flag;
	private String loginModuleStackRef;
	private String module;
	private Map moduleOptions;

	public AuthModule(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public AuthModule code(String value) {
		this.code = value;
		return (AuthModule) this;
	}

	/**
	 * The flag controls how the module participates in the overall procedure. Allowed values are requisite, required, sufficient or optional.
	 */
	@ModelNodeBinding(detypedName = "flag")
	public String flag() {
		return this.flag;
	}

	/**
	 * The flag controls how the module participates in the overall procedure. Allowed values are requisite, required, sufficient or optional.
	 */
	@SuppressWarnings("unchecked")
	public AuthModule flag(String value) {
		this.flag = value;
		return (AuthModule) this;
	}

	/**
	 * Reference to a login module stack name previously configured in the same security domain.
	 */
	@ModelNodeBinding(detypedName = "login-module-stack-ref")
	public String loginModuleStackRef() {
		return this.loginModuleStackRef;
	}

	/**
	 * Reference to a login module stack name previously configured in the same security domain.
	 */
	@SuppressWarnings("unchecked")
	public AuthModule loginModuleStackRef(String value) {
		this.loginModuleStackRef = value;
		return (AuthModule) this;
	}

	/**
	 * Name of JBoss Module where the mapping module code is located.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of JBoss Module where the mapping module code is located.
	 */
	@SuppressWarnings("unchecked")
	public AuthModule module(String value) {
		this.module = value;
		return (AuthModule) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public AuthModule moduleOptions(Map value) {
		this.moduleOptions = value;
		return (AuthModule) this;
	}
}