package org.wildfly.swarm.config.security.security_domain.authentication;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
/**
 * List of "named" login modules that are used by jaspi authentication modules.
 */
@ResourceType("login-module-stack")
public class LoginModuleStack {

	private String key;
	private LoginModuleStackResources subresources = new LoginModuleStackResources();

	public LoginModuleStack(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	public LoginModuleStackResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.authentication.LoginModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.authentication.LoginModule objects.
	 */
	@SuppressWarnings("unchecked")
	public LoginModuleStack loginModules(
			List<org.wildfly.swarm.config.security.security_domain.authentication.LoginModule> value) {
		this.subresources.loginModules.addAll(value);
		return (LoginModuleStack) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.authentication.LoginModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.authentication.LoginModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoginModuleStack loginModule(LoginModule value) {
		this.subresources.loginModules.add(value);
		return (LoginModuleStack) this;
	}

	/**
	 * Child mutators for LoginModuleStack
	 */
	public class LoginModuleStackResources {
		/**
		 * List of authentication modules
		 */
		private List<org.wildfly.swarm.config.security.security_domain.authentication.LoginModule> loginModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.authentication.LoginModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LoginModule> loginModules() {
			return this.loginModules;
		}
	}
}