package org.wildfly.swarm.config.undertow;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.ErrorPage;
import org.wildfly.swarm.config.undertow.configuration.CustomFilter;
import org.wildfly.swarm.config.undertow.configuration.Gzip;
import org.wildfly.swarm.config.undertow.configuration.ModCluster;
import org.wildfly.swarm.config.undertow.configuration.ExpressionFilter;
import org.wildfly.swarm.config.undertow.configuration.ResponseHeader;
import org.wildfly.swarm.config.undertow.configuration.Rewrite;
import org.wildfly.swarm.config.undertow.configuration.ConnectionLimit;
/**
 * Undertow filters
 */
@ResourceType("configuration")
@Implicit
public class FilterConfiguration {

	private String key;
	private FilterConfigurationResources subresources = new FilterConfigurationResources();

	public FilterConfiguration() {
		this.key = "filter";
	}

	public String getKey() {
		return this.key;
	}

	public FilterConfigurationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.ErrorPage objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.ErrorPage objects.
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration errorPages(
			List<org.wildfly.swarm.config.undertow.configuration.ErrorPage> value) {
		this.subresources.errorPages.addAll(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.ErrorPage object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.ErrorPage to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration errorPage(ErrorPage value) {
		this.subresources.errorPages.add(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.CustomFilter objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.CustomFilter objects.
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration customFilters(
			List<org.wildfly.swarm.config.undertow.configuration.CustomFilter> value) {
		this.subresources.customFilters.addAll(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.CustomFilter object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.CustomFilter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration customFilter(CustomFilter value) {
		this.subresources.customFilters.add(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.Gzip objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.Gzip objects.
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration gzips(
			List<org.wildfly.swarm.config.undertow.configuration.Gzip> value) {
		this.subresources.gzips.addAll(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.Gzip object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.Gzip to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration gzip(Gzip value) {
		this.subresources.gzips.add(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.ModCluster objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.ModCluster objects.
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration modClusters(
			List<org.wildfly.swarm.config.undertow.configuration.ModCluster> value) {
		this.subresources.modClusters.addAll(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.ModCluster object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.ModCluster to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration modCluster(ModCluster value) {
		this.subresources.modClusters.add(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.ExpressionFilter objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.ExpressionFilter objects.
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration expressionFilters(
			List<org.wildfly.swarm.config.undertow.configuration.ExpressionFilter> value) {
		this.subresources.expressionFilters.addAll(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.ExpressionFilter object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.ExpressionFilter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration expressionFilter(ExpressionFilter value) {
		this.subresources.expressionFilters.add(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.ResponseHeader objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.ResponseHeader objects.
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration responseHeaders(
			List<org.wildfly.swarm.config.undertow.configuration.ResponseHeader> value) {
		this.subresources.responseHeaders.addAll(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.ResponseHeader object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.ResponseHeader to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration responseHeader(ResponseHeader value) {
		this.subresources.responseHeaders.add(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.Rewrite objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.Rewrite objects.
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration rewrites(
			List<org.wildfly.swarm.config.undertow.configuration.Rewrite> value) {
		this.subresources.rewrites.addAll(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.Rewrite object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.Rewrite to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration rewrite(Rewrite value) {
		this.subresources.rewrites.add(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.ConnectionLimit objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.ConnectionLimit objects.
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration connectionLimits(
			List<org.wildfly.swarm.config.undertow.configuration.ConnectionLimit> value) {
		this.subresources.connectionLimits.addAll(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.ConnectionLimit object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.ConnectionLimit to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public FilterConfiguration connectionLimit(ConnectionLimit value) {
		this.subresources.connectionLimits.add(value);
		return (FilterConfiguration) this;
	}

	/**
	 * Child mutators for FilterConfiguration
	 */
	public class FilterConfigurationResources {
		/**
		 * The error pages
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.ErrorPage> errorPages = new java.util.ArrayList<>();
		/**
		 * Custom filter
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.CustomFilter> customFilters = new java.util.ArrayList<>();
		/**
		 * Defines gzip filter
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.Gzip> gzips = new java.util.ArrayList<>();
		/**
		 * A mod-cluster front end load balancer
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.ModCluster> modClusters = new java.util.ArrayList<>();
		/**
		 * A filter parsed from the undertow expression language
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.ExpressionFilter> expressionFilters = new java.util.ArrayList<>();
		/**
		 * Response header filter allows you to add custom headers.
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.ResponseHeader> responseHeaders = new java.util.ArrayList<>();
		/**
		 * A rewrite (or redirect) filter
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.Rewrite> rewrites = new java.util.ArrayList<>();
		/**
		 * Connection limiter handler
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.ConnectionLimit> connectionLimits = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.ErrorPage resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ErrorPage> errorPages() {
			return this.errorPages;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.CustomFilter resources
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomFilter> customFilters() {
			return this.customFilters;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.Gzip resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Gzip> gzips() {
			return this.gzips;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.ModCluster resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ModCluster> modClusters() {
			return this.modClusters;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.ExpressionFilter resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ExpressionFilter> expressionFilters() {
			return this.expressionFilters;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.ResponseHeader resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ResponseHeader> responseHeaders() {
			return this.responseHeaders;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.Rewrite resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Rewrite> rewrites() {
			return this.rewrites;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.ConnectionLimit resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectionLimit> connectionLimits() {
			return this.connectionLimits;
		}
	}
}