/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.server.AjpListener;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.server.HttpListener;
import org.wildfly.swarm.config.undertow.server.HttpsListener;

@ResourceType(value="server")
public class Server {
    private String key;
    private String defaultHost;
    private String servletContainer;
    private ServerResources subresources = new ServerResources();

    public Server(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="default-host")
    public String defaultHost() {
        return this.defaultHost;
    }

    public Server defaultHost(String value) {
        this.defaultHost = value;
        return this;
    }

    @ModelNodeBinding(detypedName="servlet-container")
    public String servletContainer() {
        return this.servletContainer;
    }

    public Server servletContainer(String value) {
        this.servletContainer = value;
        return this;
    }

    public ServerResources subresources() {
        return this.subresources;
    }

    public Server hosts(List<Host> value) {
        this.subresources.hosts.addAll(value);
        return this;
    }

    public Server host(Host value) {
        this.subresources.hosts.add(value);
        return this;
    }

    public Server httpListeners(List<HttpListener> value) {
        this.subresources.httpListeners.addAll(value);
        return this;
    }

    public Server httpListener(HttpListener value) {
        this.subresources.httpListeners.add(value);
        return this;
    }

    public Server ajpListeners(List<AjpListener> value) {
        this.subresources.ajpListeners.addAll(value);
        return this;
    }

    public Server ajpListener(AjpListener value) {
        this.subresources.ajpListeners.add(value);
        return this;
    }

    public Server httpsListeners(List<HttpsListener> value) {
        this.subresources.httpsListeners.addAll(value);
        return this;
    }

    public Server httpsListener(HttpsListener value) {
        this.subresources.httpsListeners.add(value);
        return this;
    }

    public class ServerResources {
        private List<Host> hosts = new ArrayList<Host>();
        private List<HttpListener> httpListeners = new ArrayList<HttpListener>();
        private List<AjpListener> ajpListeners = new ArrayList<AjpListener>();
        private List<HttpsListener> httpsListeners = new ArrayList<HttpsListener>();

        @Subresource
        public List<Host> hosts() {
            return this.hosts;
        }

        @Subresource
        public List<HttpListener> httpListeners() {
            return this.httpListeners;
        }

        @Subresource
        public List<AjpListener> ajpListeners() {
            return this.ajpListeners;
        }

        @Subresource
        public List<HttpsListener> httpsListeners() {
            return this.httpsListeners;
        }
    }
}

